/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.nonAxisChart;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.chartData.interfaces.IPieChartDataSet;
import org.krysalis.jcharts.chartData.processors.PieChartDataProcessor;
import org.krysalis.jcharts.imageMap.CircleMapArea;
import org.krysalis.jcharts.imageMap.ImageMap;
import org.krysalis.jcharts.imageMap.PolyMapArea;
import org.krysalis.jcharts.nonAxisChart.PieLabels;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PieChart2DProperties;
import org.krysalis.jcharts.test.HTMLChartTestable;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.types.PieLabelType;

public class PieChart2D
extends Chart
implements HTMLChartTestable {
    private float pieX;
    private float pieY;
    private float diameter;
    private IPieChartDataSet iPieChartDataSet;
    private PieChartDataProcessor pieChartDataProcessor;
    private PieLabels pieLabels;

    public PieChart2D(IPieChartDataSet iPieChartDataSet, LegendProperties legendProperties, ChartProperties chartProperties, int n, int n2) {
        super(legendProperties, chartProperties, n, n2);
        this.iPieChartDataSet = iPieChartDataSet;
    }

    protected void renderChart() {
        float f;
        PieChart2DProperties pieChart2DProperties = (PieChart2DProperties)this.iPieChartDataSet.getChartTypeProperties();
        FontRenderContext fontRenderContext = super.getGraphics2D().getFontRenderContext();
        this.pieChartDataProcessor = new PieChartDataProcessor(this.iPieChartDataSet);
        this.pieChartDataProcessor.processData();
        float f2 = super.getChartProperties().getEdgePadding() * 2.0f;
        float f3 = super.getImageWidth() / 2;
        float f4 = super.getImageHeight() / 2;
        float f5 = super.renderChartTitle(this.iPieChartDataSet.getChartTitle(), fontRenderContext);
        float f6 = (float)super.getImageWidth() - f2;
        float f7 = (float)super.getImageHeight() - f2;
        f7 -= f5;
        if (!pieChart2DProperties.getPieLabelType().equals(PieLabelType.NO_LABELS)) {
            this.pieLabels = new PieLabels(pieChart2DProperties, this.iPieChartDataSet, fontRenderContext);
            if (this.iPieChartDataSet.getNumberOfDataItems() != 1) {
                f6 -= this.pieLabels.getWidestLabelTimesTwo();
                f6 -= pieChart2DProperties.getTickLength() * 2.0f;
            }
            f7 -= this.pieLabels.getTallestLabelTimesTwo();
            f7 -= pieChart2DProperties.getTickLength() * 2.0f;
        }
        if (this.getLegend() != null) {
            f = 0.0f;
            float f8 = 0.0f;
            this.getLegend().calculateDrawingValues(this.iPieChartDataSet);
            if (this.getLegend().getLegendProperties().getPlacement() == 1 || this.getLegend().getLegendProperties().getPlacement() == 2) {
                f6 -= this.getLegend().getWidth();
                this.diameter = Math.max(f6 -= (float)this.getLegend().getLegendProperties().getChartPadding(), 1.0f);
                float f9 = this.diameter = Math.min(this.diameter, f7);
                f9 += this.getLegend().getWidth();
                f9 += (float)this.getLegend().getLegendProperties().getChartPadding();
                if (this.pieLabels != null) {
                    f9 += this.pieLabels.getWidestLabel() * 2.0f;
                    f9 += pieChart2DProperties.getTickLength() * 2.0f;
                }
                if (this.getLegend().getLegendProperties().getPlacement() == 1) {
                    this.pieX = f3 - f9 / 2.0f;
                    if (this.pieLabels != null) {
                        this.pieX += this.pieLabels.getWidestLabel();
                        this.pieX += pieChart2DProperties.getTickLength();
                        f += this.pieLabels.getWidestLabel();
                        f += pieChart2DProperties.getTickLength();
                    }
                    f += this.pieX + this.diameter;
                    f += (float)this.getLegend().getLegendProperties().getChartPadding();
                } else {
                    f = f3 - f9 / 2.0f;
                    if (this.pieLabels != null) {
                        this.pieX = f;
                        this.pieX += this.getLegend().getWidth();
                        this.pieX += (float)this.getLegend().getLegendProperties().getChartPadding();
                        this.pieX += this.pieLabels.getWidestLabel();
                        this.pieX += pieChart2DProperties.getTickLength();
                    }
                }
                f8 = f4 - (float)(this.getLegend().getHeight() / 2);
                this.pieY = f4 - this.diameter / 2.0f;
            } else {
                f7 -= (float)this.getLegend().getHeight();
                this.diameter = Math.max(f7 -= (float)this.getLegend().getLegendProperties().getChartPadding(), 1.0f);
                this.diameter = Math.min(this.diameter, f6);
                if (this.getLegend().getLegendProperties().getPlacement() == 0) {
                    this.pieY = super.getChartProperties().getEdgePadding();
                    this.pieY += f5;
                    f8 += this.diameter;
                    if (this.pieLabels != null) {
                        this.pieY += this.pieLabels.getTallestLabel();
                        this.pieY += pieChart2DProperties.getTickLength();
                        f8 += this.pieLabels.getTallestLabel();
                        f8 += pieChart2DProperties.getTickLength();
                    }
                    f8 += this.pieY;
                    f8 += (float)this.getLegend().getLegendProperties().getChartPadding();
                } else {
                    f8 = super.getChartProperties().getEdgePadding();
                    this.pieY = f8 += f5;
                    this.pieY += (float)this.getLegend().getHeight();
                    this.pieY += (float)this.getLegend().getLegendProperties().getChartPadding();
                    if (this.pieLabels != null) {
                        this.pieY += this.pieLabels.getTallestLabel();
                        this.pieY += pieChart2DProperties.getTickLength();
                    }
                }
                f = f3 - this.getLegend().getWidth() / 2.0f;
                this.pieX = f3 - this.diameter / 2.0f;
            }
            super.getLegend().setX(f);
            super.getLegend().setY(f8);
            super.getLegend().render();
        } else {
            this.diameter = Math.min(f7, f6);
            f = this.diameter / 2.0f;
            this.pieX = f3 - f;
            this.pieY = f4 - f;
        }
        if (super.getGenerateImageMapFlag()) {
            ImageMap imageMap = new ImageMap(this.iPieChartDataSet.getNumberOfDataItems());
            super.setImageMap(imageMap);
        }
        PieChart2D.render(this);
    }

    static void render(PieChart2D pieChart2D) {
        Graphics2D graphics2D = pieChart2D.getGraphics2D();
        PieChart2DProperties pieChart2DProperties = (PieChart2DProperties)pieChart2D.iPieChartDataSet.getChartTypeProperties();
        pieChart2DProperties.getBorderChartStroke().setupGraphics2D(graphics2D);
        int n = 3;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float[][] fArray = null;
        if (pieChart2D.getImageMap() != null) {
            f = (float)((double)pieChart2D.diameter / 2.0);
            f2 = f + pieChart2D.pieX;
            f3 = f + pieChart2D.pieY;
            fArray = new float[pieChart2D.iPieChartDataSet.getNumberOfDataItems() * (n + 1)][2];
        }
        float f4 = pieChart2DProperties.getZeroDegreeOffset();
        double d = 0.0;
        if (pieChart2D.iPieChartDataSet.getNumberOfDataItems() == 1) {
            Arc2D.Double double_ = new Arc2D.Double(pieChart2D.pieX, pieChart2D.pieY, pieChart2D.diameter, pieChart2D.diameter, f4, 360.0, 0);
            graphics2D.setPaint(pieChart2D.iPieChartDataSet.getPaint(0));
            graphics2D.fill(double_);
            pieChart2DProperties.getBorderChartStroke().draw(graphics2D, double_);
            if (pieChart2D.getImageMap() != null) {
                CircleMapArea circleMapArea = new CircleMapArea(f2, f3, pieChart2D.iPieChartDataSet.getValue(0), null, pieChart2D.iPieChartDataSet.getLegendLabel(0));
                circleMapArea.setRadius((int)pieChart2D.diameter);
                pieChart2D.getImageMap().addImageMapArea(circleMapArea);
            }
            if (pieChart2D.pieLabels != null) {
                float f5 = pieChart2D.pieX + pieChart2D.diameter / 2.0f - pieChart2D.pieLabels.getTextTag(0).getWidth() / 2.0f;
                float f6 = pieChart2D.pieY - pieChart2DProperties.getTickLength();
                pieChart2DProperties.getValueLabelFont().setupGraphics2D(graphics2D);
                graphics2D.drawString(pieChart2D.pieLabels.getTextTag(0).getText(), f5, f6);
            }
        } else {
            int n2;
            Arc2D.Double double_ = new Arc2D.Double(pieChart2D.pieX, pieChart2D.pieY, pieChart2D.diameter, pieChart2D.diameter, f4, 360.0, 2);
            int n3 = 0;
            for (n2 = 0; n2 < pieChart2D.iPieChartDataSet.getNumberOfDataItems(); ++n2) {
                double d2;
                double d3;
                double d4;
                double d5;
                d = pieChart2D.pieChartDataProcessor.getPercentageOfPie(n2);
                double_.setAngleStart(f4);
                double_.setAngleExtent(d);
                graphics2D.setPaint(pieChart2D.iPieChartDataSet.getPaint(n2));
                graphics2D.fill(double_);
                pieChart2DProperties.getBorderChartStroke().draw(graphics2D, double_);
                if (pieChart2D.pieLabels != null) {
                    d5 = (double)f4 + d / 2.0;
                    if (d5 > 360.0) {
                        d5 -= 360.0;
                    }
                    d4 = Math.toRadians(d5);
                    d3 = Math.cos(d4);
                    d2 = Math.sin(d4);
                    f = (float)((double)pieChart2D.diameter / 2.0);
                    float f7 = (float)(d3 * (double)f);
                    float f8 = (float)(-(d2 * (double)f));
                    float f9 = (float)(d3 * (double)(f + pieChart2DProperties.getTickLength()));
                    float f10 = (float)(-(d2 * (double)(f + pieChart2DProperties.getTickLength())));
                    f2 = f + pieChart2D.pieX;
                    f3 = f + pieChart2D.pieY;
                    pieChart2DProperties.getValueLabelFont().setupGraphics2D(graphics2D);
                    graphics2D.draw(new Line2D.Double(f2 + f7, f3 + f8, f2 + f9, f3 + f10));
                    float f11 = f3 + f10;
                    if (d5 > 60.0 && d5 < 120.0) {
                        f11 -= pieChart2D.pieLabels.getTextTag(n2).getFontDescent();
                    } else if (d5 > 240.0 && d5 < 300.0) {
                        f11 += pieChart2D.pieLabels.getTextTag(n2).getFontAscent();
                    }
                    if (d5 > 90.0 && d5 < 270.0) {
                        graphics2D.drawString(pieChart2D.pieLabels.getTextTag(n2).getText(), f2 + f9 - pieChart2D.pieLabels.getTextTag(n2).getWidth() - pieChart2DProperties.getTickLength(), f11);
                    } else {
                        graphics2D.drawString(pieChart2D.pieLabels.getTextTag(n2).getText(), f2 + f9 + pieChart2DProperties.getTickLength(), f11);
                    }
                }
                if (pieChart2D.getImageMap() != null) {
                    d5 = f4;
                    d2 = d / (double)n;
                    for (int i = 0; i <= n; ++i) {
                        d4 = Math.cos(Math.toRadians(d5));
                        d3 = Math.sin(Math.toRadians(d5));
                        fArray[n3][0] = f2 + (float)(d4 * (double)f);
                        fArray[n3][1] = f3 + (float)(-(d3 * (double)f));
                        ++n3;
                        d5 += d2;
                    }
                }
                f4 = (float)((double)f4 + d);
            }
            if (pieChart2D.getImageMap() != null) {
                n2 = 0;
                for (int i = 0; i < pieChart2D.iPieChartDataSet.getNumberOfDataItems(); ++i) {
                    int n4 = 0;
                    PolyMapArea polyMapArea = new PolyMapArea(3 + n, pieChart2D.iPieChartDataSet.getValue(i), null, pieChart2D.iPieChartDataSet.getLegendLabel(i));
                    polyMapArea.addCoordinate(n4++, f2, f3);
                    for (int j = 0; j <= n; ++j) {
                        polyMapArea.addCoordinate(n4++, fArray[n2][0], fArray[n2][1]);
                        ++n2;
                    }
                    if (i + 1 == pieChart2D.iPieChartDataSet.getNumberOfDataItems()) {
                        polyMapArea.addCoordinate(n4, fArray[0][0], fArray[0][1]);
                    } else {
                        polyMapArea.addCoordinate(n4, fArray[n2][0], fArray[n2][1]);
                    }
                    pieChart2D.getImageMap().addImageMapArea(polyMapArea);
                }
            }
        }
    }

    public void toHTML(HTMLGenerator hTMLGenerator, String string) {
        if (this.getLegend() != null) {
            hTMLGenerator.chartTableRowStart();
            this.getLegend().toHTML(hTMLGenerator);
            hTMLGenerator.chartTableRowEnd();
        }
        hTMLGenerator.chartTableEnd();
    }
}

