/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.interfaces.IDataSeries;
import org.krysalis.jcharts.chartData.interfaces.IStockChartDataSet;
import org.krysalis.jcharts.imageMap.CircleMapArea;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.StockChartProperties;
import org.krysalis.jcharts.types.StockChartDataType;

abstract class StockChart {
    StockChart() {
    }

    static final void render(AxisChart axisChart, IStockChartDataSet iStockChartDataSet) {
        StockChartProperties stockChartProperties = (StockChartProperties)iStockChartDataSet.getChartTypeProperties();
        Graphics2D graphics2D = axisChart.getGraphics2D();
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
        IDataSeries iDataSeries = (IDataSeries)axisChart.getIAxisDataSeries();
        Line2D.Float float_ = new Line2D.Float(axisChart.getXAxis().getTickStart(), 0.0f, axisChart.getXAxis().getTickStart(), 0.0f);
        Line2D.Float float_2 = null;
        if (iStockChartDataSet.hasOpenValues()) {
            float_2 = new Line2D.Float(axisChart.getXAxis().getTickStart() - (float)stockChartProperties.getOpenPixelLength() - 1.0f, 0.0f, axisChart.getXAxis().getTickStart() - 1.0f, 0.0f);
        }
        Line2D.Float float_3 = null;
        if (iStockChartDataSet.hasCloseValues()) {
            float_3 = new Line2D.Float(axisChart.getXAxis().getTickStart() + 1.0f, 0.0f, axisChart.getXAxis().getTickStart() + (float)stockChartProperties.getClosePixelLength() + 1.0f, 0.0f);
        }
        for (int i = 0; i < iStockChartDataSet.getNumberOfDataItems(); ++i) {
            float_.y1 = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iStockChartDataSet.getLowValue(i), axisChart.getYAxis().getScaleCalculator().getMinValue());
            float_.y2 = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iStockChartDataSet.getHighValue(i), axisChart.getYAxis().getScaleCalculator().getMinValue());
            String string = axisChart.getXAxis().getAxisLabelsGroup() != null ? axisChart.getXAxis().getAxisLabelsGroup().getTextTag(i).getText() : null;
            if (axisChart.getGenerateImageMapFlag()) {
                axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_.x1, float_.y1, iStockChartDataSet.getLowValue(i), string, iStockChartDataSet.getLegendLabel(StockChartDataType.LOW.getInt())));
                axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_.x2, float_.y2, iStockChartDataSet.getHighValue(i), string, iStockChartDataSet.getLegendLabel(StockChartDataType.HIGH.getInt())));
            }
            graphics2D.setPaint(iStockChartDataSet.getPaint(StockChartDataType.HIGH.getInt()));
            graphics2D.setStroke(stockChartProperties.getHiLowStroke());
            graphics2D.draw(float_);
            float_.x1 += axisChart.getXAxis().getScalePixelWidth();
            float_.x2 = float_.x1;
            if (float_2 != null && iStockChartDataSet.getOpenValue(i) != Double.NaN) {
                float_2.y2 = float_2.y1 = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iStockChartDataSet.getOpenValue(i), axisChart.getYAxis().getScaleCalculator().getMinValue());
                graphics2D.setPaint(iStockChartDataSet.getPaint(StockChartDataType.OPEN.getInt()));
                graphics2D.setStroke(stockChartProperties.getOpenStroke());
                graphics2D.draw(float_2);
                if (axisChart.getGenerateImageMapFlag()) {
                    axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_2.x1, float_2.y1, iStockChartDataSet.getOpenValue(i), string, iStockChartDataSet.getLegendLabel(StockChartDataType.OPEN.getInt())));
                }
                float_2.x1 += axisChart.getXAxis().getScalePixelWidth();
                float_2.x2 += axisChart.getXAxis().getScalePixelWidth();
            }
            if (float_3 == null || iStockChartDataSet.getOpenValue(i) == Double.NaN) continue;
            float_3.y2 = float_3.y1 = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iStockChartDataSet.getCloseValue(i), axisChart.getYAxis().getScaleCalculator().getMinValue());
            graphics2D.setPaint(iStockChartDataSet.getPaint(StockChartDataType.CLOSE.getInt()));
            graphics2D.setStroke(stockChartProperties.getCloseStroke());
            graphics2D.draw(float_3);
            if (axisChart.getGenerateImageMapFlag()) {
                axisChart.getImageMap().addImageMapArea(new CircleMapArea(float_3.x2, float_3.y2, iStockChartDataSet.getCloseValue(i), string, iStockChartDataSet.getLegendLabel(StockChartDataType.CLOSE.getInt())));
            }
            float_3.x1 += axisChart.getXAxis().getScalePixelWidth();
            float_3.x2 += axisChart.getXAxis().getScalePixelWidth();
        }
    }
}

