/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.application.state;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;

public class Util {
    public static UIComponent newInstance(TreeCaptureNode tcn, Map classMap) throws FacesException {
        try {
            Class t = classMap != null ? classMap.get(tcn.className) : null;
            if (t == null) {
                t = Util.loadClass(tcn.className, tcn);
                if (t != null && classMap != null) {
                    classMap.put(tcn.className, t);
                } else {
                    throw new NullPointerException();
                }
            }
            UIComponent comp = (UIComponent)t.newInstance();
            comp.setId(tcn.id);
            return comp;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static void captureChildNode(CaptureArray tree, int parent, UIComponent component) {
        if (!component.isTransient()) {
            TreeCaptureNode tcn = new TreeCaptureNode(parent, component);
            int pos = tree.index;
            tree.capture(tcn);
            Util.captureAll(tree, pos, component);
        }
    }

    public static void captureFacetNode(CaptureArray tree, int parent, String name, UIComponent component) {
        if (!component.isTransient()) {
            FacetCaptureNode fcn = new FacetCaptureNode(parent, name, component);
            int pos = tree.index;
            tree.capture(fcn);
            Util.captureAll(tree, pos, component);
        }
    }

    public static void captureAll(CaptureArray tree, int pos, UIComponent c) {
        Map m;
        int sz = c.getChildCount();
        if (sz > 0) {
            List child = c.getChildren();
            for (int i = 0; i < sz; ++i) {
                Util.captureChildNode(tree, pos, (UIComponent)child.get(i));
            }
        }
        if ((m = c.getFacets()).size() > 0) {
            Set s = m.entrySet();
            Iterator i = s.iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Util.captureFacetNode(tree, pos, (String)entry.getKey(), (UIComponent)entry.getValue());
            }
        }
    }

    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    public static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Util.getCurrentLoader(fallbackClass);
        if (name.charAt(0) == '[') {
            return Class.forName(name, true, loader);
        }
        return loader.loadClass(name);
    }

    public static UIViewRoot restoreTree(Object[] tree, Map classMap) throws FacesException {
        for (int i = 0; i < tree.length; ++i) {
            UIComponent c;
            if (tree[i] instanceof FacetCaptureNode) {
                FacetCaptureNode fn = (FacetCaptureNode)tree[i];
                c = Util.newInstance(fn, classMap);
                tree[i] = c;
                if (i == fn.parentIdx) continue;
                ((UIComponent)tree[fn.parentIdx]).getFacets().put(fn.facetName, c);
                continue;
            }
            TreeCaptureNode tn = (TreeCaptureNode)tree[i];
            c = Util.newInstance(tn, classMap);
            tree[i] = c;
            if (i == tn.parentIdx) continue;
            ((UIComponent)tree[tn.parentIdx]).getChildren().add(c);
        }
        return (UIViewRoot)tree[0];
    }

    public static class CaptureArray {
        int index;
        Object[] capturedNodes = new Object[64];

        private void expand() {
            Object[] newArray = new Object[this.capturedNodes.length * 2];
            System.arraycopy(this.capturedNodes, 0, newArray, 0, this.capturedNodes.length);
            this.capturedNodes = newArray;
        }

        public void capture(Object n) {
            if (this.index == this.capturedNodes.length) {
                this.expand();
            }
            this.capturedNodes[this.index++] = n;
        }

        public Object[] toArray() {
            Object[] returnVal = new Object[this.index];
            System.arraycopy(this.capturedNodes, 0, returnVal, 0, this.index);
            return returnVal;
        }
    }

    private static final class FacetCaptureNode
    extends TreeCaptureNode {
        public String facetName;
        private static final long serialVersionUID = -4529208165281928474L;

        public FacetCaptureNode() {
        }

        public FacetCaptureNode(int parent, String name, UIComponent c) {
            super(parent, c);
            this.facetName = name;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.facetName = in.readUTF();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeUTF(this.facetName);
        }
    }

    private static class TreeCaptureNode
    implements Externalizable {
        private static final String NO_ID = "";
        public String className;
        public String id;
        public int parentIdx;
        static final long serialVersionUID = -214427652801663237L;

        public TreeCaptureNode() {
        }

        public TreeCaptureNode(int parent, UIComponent c) {
            this.parentIdx = parent;
            this.id = c.getId();
            this.className = c.getClass().getName();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.parentIdx);
            out.writeUTF(this.className);
            if (this.id != null) {
                out.writeUTF(this.id);
            } else {
                out.writeUTF(NO_ID);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.parentIdx = in.readInt();
            this.className = in.readUTF();
            this.id = in.readUTF();
            if (this.id.length() == 0) {
                this.id = null;
            }
        }
    }
}

