/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.util.event.servlet;

import com.icesoft.faces.util.event.servlet.AnnouncementMessageHandler;
import com.icesoft.faces.util.event.servlet.ContextDestroyedEvent;
import com.icesoft.faces.util.event.servlet.ContextEvent;
import com.icesoft.faces.util.event.servlet.ContextEventListener;
import com.icesoft.faces.util.event.servlet.ICEfacesIDDisposedEvent;
import com.icesoft.faces.util.event.servlet.ICEfacesIDRetrievedEvent;
import com.icesoft.faces.util.event.servlet.SessionDestroyedEvent;
import com.icesoft.faces.util.event.servlet.ViewNumberDisposedEvent;
import com.icesoft.faces.util.event.servlet.ViewNumberRetrievedEvent;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.servlet.CoreMessageService;
import com.icesoft.faces.webapp.http.servlet.ServletContextConfiguration;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.util.Properties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextEventRepeater
implements HttpSessionListener,
ServletContextListener {
    private static final Log LOG = LogFactory.getLog((Class)ContextEventRepeater.class);
    private static final String BUFFERED_CONTEXT_EVENTS_MESSAGE_TYPE = "BufferedContextEvents";
    private static final String CONTEXT_EVENT_MESSAGE_TYPE = "ContextEvent";
    private static SessionDispatcher.Listener SessionDispatcherListener = new SessionDispatcher.Listener();
    private static final List BUFFERED_CONTEXT_EVENTS = new ArrayList();
    private static final Map LISTENERS = new WeakHashMap();
    private static final Object MESSAGE_SERVICE_CLIENT_LOCK = new Object();
    private static Configuration servletContextConfiguration;
    private static String blockingRequestHandlerContext;
    private static CoreMessageService coreMessageService;
    private static AnnouncementMessageHandler.Callback callback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ContextEventListener contextEventListener) {
        if (contextEventListener != null) {
            Map map = LISTENERS;
            synchronized (map) {
                if (!LISTENERS.containsKey(contextEventListener)) {
                    LISTENERS.put(contextEventListener, null);
                    if (contextEventListener.receiveBufferedEvents()) {
                        ContextEventRepeater.sendBufferedEvents(contextEventListener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent event) {
        SessionDispatcherListener.contextDestroyed(event);
        ContextDestroyedEvent contextDestroyedEvent = new ContextDestroyedEvent(event);
        Map map = LISTENERS;
        synchronized (map) {
            Iterator _listeners = LISTENERS.keySet().iterator();
            while (_listeners.hasNext()) {
                ((ContextEventListener)_listeners.next()).contextDestroyed(contextDestroyedEvent);
            }
            LISTENERS.clear();
            List list = BUFFERED_CONTEXT_EVENTS;
            synchronized (list) {
                BUFFERED_CONTEXT_EVENTS.clear();
            }
        }
        if (LOG.isInfoEnabled()) {
            ServletContext servletContext = contextDestroyedEvent.getServletContext();
            LOG.info((Object)("Servlet Context Name: " + servletContext.getServletContextName() + ", " + "Server Info: " + servletContext.getServerInfo()));
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        servletContextConfiguration = new ServletContextConfiguration("com.icesoft.faces", event.getServletContext());
        SessionDispatcherListener.contextInitialized(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iceFacesIdDisposed(Object source, String iceFacesId) {
        ICEfacesIDDisposedEvent iceFacesIdDisposedEvent = new ICEfacesIDDisposedEvent(source, iceFacesId);
        Map map = LISTENERS;
        synchronized (map) {
            Iterator _listeners = LISTENERS.keySet().iterator();
            while (_listeners.hasNext()) {
                ((ContextEventListener)_listeners.next()).iceFacesIdDisposed(iceFacesIdDisposedEvent);
            }
            ContextEventRepeater.removeBufferedEvents(iceFacesId);
        }
        if (coreMessageService != null) {
            Properties _messageProperties = new Properties();
            _messageProperties.setStringProperty("destination_servletContextPath", blockingRequestHandlerContext);
            coreMessageService.publish(ContextEventRepeater.createMessage(iceFacesIdDisposedEvent), _messageProperties, CONTEXT_EVENT_MESSAGE_TYPE, "icefacesPush");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ICEfaces ID disposed: " + iceFacesIdDisposedEvent.getICEfacesID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iceFacesIdRetrieved(Object source, String iceFacesId) {
        ICEfacesIDRetrievedEvent iceFacesIdRetrievedEvent = new ICEfacesIDRetrievedEvent(source, iceFacesId);
        Map map = LISTENERS;
        synchronized (map) {
            List list = BUFFERED_CONTEXT_EVENTS;
            synchronized (list) {
                BUFFERED_CONTEXT_EVENTS.add(iceFacesIdRetrievedEvent);
                Iterator _listeners = LISTENERS.keySet().iterator();
                while (_listeners.hasNext()) {
                    ((ContextEventListener)_listeners.next()).iceFacesIdRetrieved(iceFacesIdRetrievedEvent);
                }
            }
        }
        if (coreMessageService != null) {
            Properties _messageProperties = new Properties();
            _messageProperties.setStringProperty("destination_servletContextPath", blockingRequestHandlerContext);
            coreMessageService.publish(ContextEventRepeater.createMessage(iceFacesIdRetrievedEvent), _messageProperties, CONTEXT_EVENT_MESSAGE_TYPE, "icefacesPush");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ICEfaces ID retrieved: " + iceFacesIdRetrievedEvent.getICEfacesID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(ContextEventListener contextEventListener) {
        if (contextEventListener != null) {
            Map map = LISTENERS;
            synchronized (map) {
                if (LISTENERS.containsKey(contextEventListener)) {
                    LISTENERS.remove(contextEventListener);
                }
            }
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Session Created event: " + event.getSession().getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Session Destroyed event: " + event.getSession().getId()));
        }
        SessionDispatcherListener.sessionDestroyed(event);
        SessionDestroyedEvent sessionDestroyedEvent = new SessionDestroyedEvent(event);
        Map map = LISTENERS;
        synchronized (map) {
            Iterator _listeners = LISTENERS.keySet().iterator();
            while (_listeners.hasNext()) {
                ((ContextEventListener)_listeners.next()).sessionDestroyed(sessionDestroyedEvent);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ICEfaces ID: " + sessionDestroyedEvent.getICEfacesID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCoreMessageService(CoreMessageService messageService) {
        if (messageService != null) {
            Object object = MESSAGE_SERVICE_CLIENT_LOCK;
            synchronized (object) {
                if (coreMessageService == null) {
                    coreMessageService = messageService;
                    coreMessageService.getAnnouncementMessageHandler().addCallback(callback);
                    blockingRequestHandlerContext = servletContextConfiguration.getAttribute("blockingRequestHandlerContext", "push-server");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewNumberDisposed(Object source, String iceFacesId, int viewNumber) {
        ViewNumberDisposedEvent viewNumberDisposedEvent = new ViewNumberDisposedEvent(source, iceFacesId, viewNumber);
        Map map = LISTENERS;
        synchronized (map) {
            Iterator _listeners = LISTENERS.keySet().iterator();
            while (_listeners.hasNext()) {
                ((ContextEventListener)_listeners.next()).viewNumberDisposed(viewNumberDisposedEvent);
            }
            ContextEventRepeater.removeBufferedEvents(iceFacesId, viewNumber);
        }
        if (coreMessageService != null) {
            Properties _messageProperties = new Properties();
            _messageProperties.setStringProperty("destination_servletContextPath", blockingRequestHandlerContext);
            coreMessageService.publish(ContextEventRepeater.createMessage(viewNumberDisposedEvent), _messageProperties, CONTEXT_EVENT_MESSAGE_TYPE, "icefacesPush");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("View Number disposed: " + viewNumberDisposedEvent.getViewNumber() + " " + "[ICEfaces ID: " + viewNumberDisposedEvent.getICEfacesID() + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewNumberRetrieved(Object source, String iceFacesId, int viewNumber) {
        ViewNumberRetrievedEvent viewNumberRetrievedEvent = new ViewNumberRetrievedEvent(source, iceFacesId, viewNumber);
        Map map = LISTENERS;
        synchronized (map) {
            List list = BUFFERED_CONTEXT_EVENTS;
            synchronized (list) {
                BUFFERED_CONTEXT_EVENTS.add(viewNumberRetrievedEvent);
                Iterator _listeners = LISTENERS.keySet().iterator();
                while (_listeners.hasNext()) {
                    ((ContextEventListener)_listeners.next()).viewNumberRetrieved(viewNumberRetrievedEvent);
                }
            }
        }
        if (coreMessageService != null) {
            Properties _messageProperties = new Properties();
            _messageProperties.setStringProperty("destination_servletContextPath", blockingRequestHandlerContext);
            coreMessageService.publish(ContextEventRepeater.createMessage(viewNumberRetrievedEvent), _messageProperties, CONTEXT_EVENT_MESSAGE_TYPE, "icefacesPush");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("View Number retrieved: " + viewNumberRetrievedEvent.getViewNumber() + " " + "[ICEfaces ID: " + viewNumberRetrievedEvent.getICEfacesID() + "]"));
        }
    }

    private static String createMessage(ContextEvent event) {
        if (event instanceof ICEfacesIDDisposedEvent) {
            return "ICEfacesIDDisposed;" + ((ICEfacesIDDisposedEvent)event).getICEfacesID();
        }
        if (event instanceof ICEfacesIDRetrievedEvent) {
            return "ICEfacesIDRetrieved;" + ((ICEfacesIDRetrievedEvent)event).getICEfacesID();
        }
        if (event instanceof ViewNumberDisposedEvent) {
            return "ViewNumberDisposed;" + ((ViewNumberDisposedEvent)event).getICEfacesID() + ";" + ((ViewNumberDisposedEvent)event).getViewNumber();
        }
        if (event instanceof ViewNumberRetrievedEvent) {
            return "ViewNumberRetrieved;" + ((ViewNumberRetrievedEvent)event).getICEfacesID() + ";" + ((ViewNumberRetrievedEvent)event).getViewNumber();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void removeBufferedEvents(String iceFacesId) {
        List list = BUFFERED_CONTEXT_EVENTS;
        synchronized (list) {
            Iterator _bufferedContextEvents = BUFFERED_CONTEXT_EVENTS.iterator();
            while (_bufferedContextEvents.hasNext()) {
                Object event = _bufferedContextEvents.next();
                if ((!(event instanceof ICEfacesIDRetrievedEvent) || !((ICEfacesIDRetrievedEvent)event).getICEfacesID().equals(iceFacesId)) && (!(event instanceof ViewNumberRetrievedEvent) || !((ViewNumberRetrievedEvent)event).getICEfacesID().equals(iceFacesId))) continue;
                _bufferedContextEvents.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeBufferedEvents(String iceFacesId, int viewNumber) {
        List list = BUFFERED_CONTEXT_EVENTS;
        synchronized (list) {
            Iterator _bufferedContextEvents = BUFFERED_CONTEXT_EVENTS.iterator();
            while (_bufferedContextEvents.hasNext()) {
                Object event = _bufferedContextEvents.next();
                if (!(event instanceof ViewNumberRetrievedEvent) || !((ViewNumberRetrievedEvent)event).getICEfacesID().equals(iceFacesId) || ((ViewNumberRetrievedEvent)event).getViewNumber() != viewNumber) continue;
                _bufferedContextEvents.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void sendBufferedEvents(ContextEventListener contextEventListener) {
        List list = BUFFERED_CONTEXT_EVENTS;
        synchronized (list) {
            Iterator _bufferedContextEvents = BUFFERED_CONTEXT_EVENTS.iterator();
            while (_bufferedContextEvents.hasNext()) {
                Object event = _bufferedContextEvents.next();
                if (event instanceof ICEfacesIDRetrievedEvent) {
                    contextEventListener.iceFacesIdRetrieved((ICEfacesIDRetrievedEvent)event);
                    continue;
                }
                if (!(event instanceof ViewNumberRetrievedEvent)) continue;
                contextEventListener.viewNumberRetrieved((ViewNumberRetrievedEvent)event);
            }
        }
    }

    static {
        callback = new AnnouncementMessageHandler.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void publishBufferedContextEvents() {
                List list = BUFFERED_CONTEXT_EVENTS;
                synchronized (list) {
                    ContextEvent[] _contextEvents = BUFFERED_CONTEXT_EVENTS.toArray(new ContextEvent[BUFFERED_CONTEXT_EVENTS.size()]);
                    if (_contextEvents.length != 0) {
                        StringBuffer _message = new StringBuffer();
                        for (int i = 0; i < _contextEvents.length; ++i) {
                            if (i != 0) {
                                _message.append("\r\n");
                            }
                            _message.append(ContextEventRepeater.createMessage(_contextEvents[i]));
                        }
                        Properties _messageProperties = new Properties();
                        _messageProperties.setStringProperty("destination_servletContextPath", blockingRequestHandlerContext);
                        coreMessageService.publish(_message.toString(), _messageProperties, ContextEventRepeater.BUFFERED_CONTEXT_EVENTS_MESSAGE_TYPE, "icefacesPush");
                    }
                }
            }
        };
    }
}

