/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.command;

import com.icesoft.faces.webapp.command.AbstractCommand;
import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.Macro;
import com.icesoft.faces.webapp.command.NOOP;
import com.icesoft.faces.webapp.command.Pong;
import com.icesoft.faces.webapp.command.Redirect;
import com.icesoft.faces.webapp.command.Reload;
import com.icesoft.faces.webapp.command.SessionExpired;
import com.icesoft.faces.webapp.command.UpdateElements;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.Cookie;

public class SetCookie
extends AbstractCommand {
    private static final DateFormat CookieDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss z");
    private Cookie cookie;

    public SetCookie(Cookie cookie) {
        this.cookie = cookie;
    }

    public Command coalesceWithNext(Command command) {
        return command.coalesceWithPrevious(this);
    }

    public Command coalesceWithPrevious(Macro macro) {
        macro.addCommand(this);
        return macro;
    }

    public Command coalesceWithPrevious(UpdateElements updateElements) {
        Macro macro = new Macro();
        macro.addCommand(this);
        macro.addCommand(updateElements);
        return macro;
    }

    public Command coalesceWithPrevious(Redirect redirect) {
        Macro macro = new Macro();
        macro.addCommand(this);
        macro.addCommand(redirect);
        return macro;
    }

    public Command coalesceWithPrevious(Reload reload) {
        Macro macro = new Macro();
        macro.addCommand(this);
        macro.addCommand(reload);
        return macro;
    }

    public Command coalesceWithPrevious(SessionExpired sessionExpired) {
        return sessionExpired;
    }

    public Command coalesceWithPrevious(SetCookie setCookie) {
        if (setCookie.cookie.getName().equals(this.cookie.getName())) {
            return this;
        }
        Macro macro = new Macro();
        macro.addCommand(setCookie);
        macro.addCommand(this);
        return macro;
    }

    public Command coalesceWithPrevious(Pong pong) {
        Macro macro = new Macro();
        macro.addCommand(this);
        macro.addCommand(pong);
        return macro;
    }

    public Command coalesceWithPrevious(NOOP noop) {
        return this;
    }

    public void serializeTo(Writer writer) throws IOException {
        String domain;
        String path;
        writer.write("<set-cookie>");
        writer.write(this.cookie.getName());
        writer.write("=");
        writer.write(this.cookie.getValue());
        writer.write("; ");
        int maxAge = this.cookie.getMaxAge();
        if (maxAge >= 0) {
            Date expiryDate = new Date(System.currentTimeMillis() + (long)maxAge * 1000L);
            writer.write("expires=");
            writer.write(CookieDateFormat.format(expiryDate));
            writer.write("; ");
        }
        if ((path = this.cookie.getPath()) != null) {
            writer.write("path=");
            writer.write(path);
            writer.write("; ");
        }
        if ((domain = this.cookie.getDomain()) != null) {
            writer.write("domain=");
            writer.write(domain);
            writer.write("; ");
        }
        if (this.cookie.getSecure()) {
            writer.write("secure;");
        }
        writer.write("</set-cookie>");
    }

    static {
        CookieDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

