/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.method.MapBasedMethodDefinitionSource;
import org.springframework.util.Assert;

public final class ProtectPointcutPostProcessor
implements BeanPostProcessor {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor == null ? (class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor = ProtectPointcutPostProcessor.class$("org.springframework.security.intercept.method.ProtectPointcutPostProcessor")) : class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor));
    private Map pointcutMap = new LinkedHashMap();
    private MapBasedMethodDefinitionSource mapBasedMethodDefinitionSource;
    private PointcutParser parser;
    static /* synthetic */ Class class$org$springframework$security$intercept$method$ProtectPointcutPostProcessor;
    static /* synthetic */ Class class$org$springframework$security$ConfigAttributeDefinition;

    public ProtectPointcutPostProcessor(MapBasedMethodDefinitionSource mapBasedMethodDefinitionSource) {
        Assert.notNull((Object)mapBasedMethodDefinitionSource, (String)"MapBasedMethodDefinitionSource to populate is required");
        this.mapBasedMethodDefinitionSource = mapBasedMethodDefinitionSource;
        HashSet<PointcutPrimitive> supportedPrimitives = new HashSet<PointcutPrimitive>();
        supportedPrimitives.add(PointcutPrimitive.EXECUTION);
        supportedPrimitives.add(PointcutPrimitive.ARGS);
        supportedPrimitives.add(PointcutPrimitive.REFERENCE);
        this.parser = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingContextClassloaderForResolution(supportedPrimitives);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Method[] methods;
        try {
            methods = bean.getClass().getMethods();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        block2: for (int i = 0; i < methods.length; ++i) {
            Iterator iter = this.pointcutMap.keySet().iterator();
            while (iter.hasNext()) {
                String ex = iter.next().toString();
                PointcutExpression expression = this.parser.parsePointcutExpression(ex);
                if (!this.attemptMatch(bean.getClass(), methods[i], expression, beanName)) continue;
                continue block2;
            }
        }
        return bean;
    }

    private boolean attemptMatch(Class targetClass, Method method, PointcutExpression expression, String beanName) {
        boolean matches = expression.matchesMethodExecution(method).alwaysMatches();
        if (matches) {
            ConfigAttributeDefinition attr = (ConfigAttributeDefinition)this.pointcutMap.get(expression.getPointcutExpression());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AspectJ pointcut expression '" + expression.getPointcutExpression() + "' matches target class '" + targetClass.getName() + "' (bean ID '" + beanName + "') for method '" + method + "'; registering security configuration attribute '" + attr + "'"));
            }
            this.mapBasedMethodDefinitionSource.addSecureMethod(targetClass, method.getName(), attr);
        }
        return matches;
    }

    public void setPointcutMap(Map map) {
        Assert.notEmpty((Map)map);
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String expression = i.next().toString();
            Object value = map.get(expression);
            Assert.isInstanceOf((Class)(class$org$springframework$security$ConfigAttributeDefinition == null ? ProtectPointcutPostProcessor.class$("org.springframework.security.ConfigAttributeDefinition") : class$org$springframework$security$ConfigAttributeDefinition), value, (String)"Map keys must be instances of ConfigAttributeDefinition");
            this.addPointcut(expression, (ConfigAttributeDefinition)value);
        }
    }

    public void addPointcut(String pointcutExpression, ConfigAttributeDefinition definition) {
        Assert.hasText((String)pointcutExpression, (String)"An AspectJ pointcut expression is required");
        Assert.notNull((Object)definition, (String)"ConfigAttributeDefinition required");
        this.pointcutMap.put(pointcutExpression, definition);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AspectJ pointcut expression '" + pointcutExpression + "' registered for security configuration attribute '" + definition + "'"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

