/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.ldap;

import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.ldap.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.LdapUserSearch;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.ldap.LdapUserDetailsMapper;
import org.springframework.security.userdetails.ldap.UserDetailsContextMapper;
import org.springframework.util.Assert;

public class LdapUserDetailsService
implements UserDetailsService {
    private LdapUserSearch userSearch;
    private LdapAuthoritiesPopulator authoritiesPopulator;
    private UserDetailsContextMapper userDetailsMapper = new LdapUserDetailsMapper();

    public LdapUserDetailsService(LdapUserSearch userSearch, LdapAuthoritiesPopulator authoritiesPopulator) {
        Assert.notNull((Object)userSearch, (String)"userSearch must not be null");
        Assert.notNull((Object)authoritiesPopulator, (String)"authoritiesPopulator must not be null");
        this.userSearch = userSearch;
        this.authoritiesPopulator = authoritiesPopulator;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        DirContextOperations userData = this.userSearch.searchForUser(username);
        GrantedAuthority[] authorities = this.authoritiesPopulator.getGrantedAuthorities(userData, username);
        return this.userDetailsMapper.mapUserFromContext(userData, username, authorities);
    }

    public void setUserDetailsMapper(UserDetailsContextMapper userDetailsMapper) {
        Assert.notNull((Object)userDetailsMapper, (String)"userDetailsMapper must not be null");
        this.userDetailsMapper = userDetailsMapper;
    }
}

