/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.interfaces.IAxisChartDataSet;
import org.krysalis.jcharts.chartData.interfaces.IDataSeries;
import org.krysalis.jcharts.imageMap.CircleMapArea;
import org.krysalis.jcharts.properties.LineChartProperties;
import org.krysalis.jcharts.properties.PropertyException;

abstract class LineChart {
    LineChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) throws PropertyException {
        Shape shape;
        int n;
        Object object;
        Graphics2D graphics2D = axisChart.getGraphics2D();
        LineChartProperties lineChartProperties = (LineChartProperties)iAxisChartDataSet.getChartTypeProperties();
        lineChartProperties.validate(iAxisChartDataSet);
        IDataSeries iDataSeries = (IDataSeries)axisChart.getIAxisDataSeries();
        float[][] fArray = new float[iAxisChartDataSet.getNumberOfDataSets()][iAxisChartDataSet.getNumberOfDataItems()];
        float f = axisChart.getXAxis().getTickStart();
        for (int i = 0; i < iAxisChartDataSet.getNumberOfDataItems(); ++i) {
            for (int j = 0; j < fArray.length; ++j) {
                if (iAxisChartDataSet.getValue(j, i) != Double.NaN) {
                    fArray[j][i] = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iAxisChartDataSet.getValue(j, i) * (double)axisChart.axisProperties.getYAxisProperties().getSecondScaleRight(), axisChart.getYAxis().getScaleCalculator().getMinValue());
                    if (!axisChart.getGenerateImageMapFlag()) continue;
                    object = axisChart.getXAxis().getAxisLabelsGroup() != null ? (Object)axisChart.getXAxis().getAxisLabelsGroup().getTextTag(i).getText() : null;
                    axisChart.getImageMap().addImageMapArea(new CircleMapArea(f, fArray[j][i], iAxisChartDataSet.getValue(j, i), (String)object, iAxisChartDataSet.getLegendLabel(j)));
                    continue;
                }
                fArray[j][i] = Float.NaN;
            }
            f += axisChart.getXAxis().getScalePixelWidth();
        }
        AffineTransform affineTransform = null;
        double[] dArray = null;
        object = null;
        if (lineChartProperties.getShapes() != null) {
            dArray = new double[iAxisChartDataSet.getNumberOfDataSets()];
            object = new double[iAxisChartDataSet.getNumberOfDataSets()];
            affineTransform = graphics2D.getTransform();
            for (n = 0; n < iAxisChartDataSet.getNumberOfDataSets(); ++n) {
                if (lineChartProperties.getShapes()[n] == null) continue;
                shape = lineChartProperties.getShapes()[n].getBounds2D();
                dArray[n] = ((RectangularShape)shape).getWidth() / 2.0;
                object[n] = ((RectangularShape)shape).getHeight() / 2.0;
            }
        }
        shape = new Line2D.Float(axisChart.getXAxis().getTickStart(), fArray[0][0], axisChart.getXAxis().getTickStart(), fArray[0][0]);
        if (fArray[0].length > 1) {
            ((Line2D.Float)shape).y2 = fArray[0][1];
        }
        for (n = 0; n < fArray.length; ++n) {
            ((Line2D.Float)shape).x1 = axisChart.getXAxis().getTickStart();
            ((Line2D.Float)shape).y1 = fArray[n][0];
            ((Line2D.Float)shape).x2 = ((Line2D.Float)shape).x1;
            for (int i = 1; i < fArray[0].length; ++i) {
                if (!Float.isNaN(fArray[n][i])) {
                    if (Float.isNaN(fArray[n][i - 1])) {
                        ((Line2D.Float)shape).x2 += axisChart.getXAxis().getScalePixelWidth();
                        ((Line2D.Float)shape).x1 = ((Line2D.Float)shape).x2;
                        ((Line2D.Float)shape).y1 = fArray[n][i];
                        ((Line2D.Float)shape).y2 = fArray[n][i];
                        continue;
                    }
                    ((Line2D.Float)shape).x2 += axisChart.getXAxis().getScalePixelWidth();
                    ((Line2D.Float)shape).y2 = fArray[n][i];
                    graphics2D.setPaint(iAxisChartDataSet.getPaint(n));
                    graphics2D.setStroke(lineChartProperties.getLineStrokes()[n]);
                    graphics2D.draw(shape);
                    if (lineChartProperties.getShapes()[n] != null) {
                        graphics2D.translate((double)((Line2D.Float)shape).x1 - dArray[n], (double)((Line2D.Float)shape).y1 - object[n]);
                        graphics2D.setPaint(iAxisChartDataSet.getPaint(n));
                        graphics2D.fill(lineChartProperties.getShapes()[n]);
                        graphics2D.setTransform(affineTransform);
                    }
                    ((Line2D.Float)shape).x1 = ((Line2D.Float)shape).x2;
                    ((Line2D.Float)shape).y1 = ((Line2D.Float)shape).y2;
                    continue;
                }
                if (!Float.isNaN(fArray[n][i - 1]) && lineChartProperties.getShapes()[n] != null) {
                    graphics2D.translate((double)((Line2D.Float)shape).x1 - dArray[n], (double)((Line2D.Float)shape).y1 - object[n]);
                    graphics2D.setPaint(iAxisChartDataSet.getPaint(n));
                    graphics2D.fill(lineChartProperties.getShapes()[n]);
                    graphics2D.setTransform(affineTransform);
                }
                ((Line2D.Float)shape).x2 += axisChart.getXAxis().getScalePixelWidth();
                ((Line2D.Float)shape).x1 = ((Line2D.Float)shape).x2;
            }
            if (Float.isNaN(fArray[n][fArray[n].length - 1]) || lineChartProperties.getShapes()[n] == null) continue;
            graphics2D.translate((double)((Line2D.Float)shape).x2 - dArray[n], (double)((Line2D.Float)shape).y2 - object[n]);
            graphics2D.setPaint(iAxisChartDataSet.getPaint(n));
            graphics2D.fill(lineChartProperties.getShapes()[n]);
            graphics2D.setTransform(affineTransform);
        }
    }
}

