/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.chartData.processors;

import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.interfaces.IScatterPlotDataSeries;
import org.krysalis.jcharts.chartData.interfaces.IScatterPlotDataSet;
import org.krysalis.jcharts.chartData.processors.AxisChartDataProcessor;
import org.krysalis.jcharts.types.ChartType;

public final class ScatterPlotDataProcessor
extends AxisChartDataProcessor {
    private double yMax;
    private double yMin;

    public void processData(AxisChart axisChart, FontRenderContext fontRenderContext) {
        IScatterPlotDataSeries iScatterPlotDataSeries = (IScatterPlotDataSeries)axisChart.getIAxisDataSeries();
        this.processDataSet(iScatterPlotDataSeries);
    }

    private void processDataSet(IScatterPlotDataSeries iScatterPlotDataSeries) {
        IScatterPlotDataSet iScatterPlotDataSet = (IScatterPlotDataSet)iScatterPlotDataSeries.getIAxisPlotDataSet(ChartType.SCATTER_PLOT);
        for (int i = 0; i < iScatterPlotDataSet.getNumberOfDataSets(); ++i) {
            for (int j = 0; j < iScatterPlotDataSet.getNumberOfDataItems(); ++j) {
                Point2D.Double double_ = iScatterPlotDataSet.getValue(i, j);
                if (double_ == null) continue;
                if (double_.getX() > super.getMaxValue()) {
                    super.setMaxValue(double_.getX());
                }
                if (double_.getX() < super.getMinValue()) {
                    super.setMinValue(double_.getX());
                }
                if (double_.getY() > this.getyMax()) {
                    this.setyMax(double_.getY());
                }
                if (!(double_.getY() < this.getyMin())) continue;
                this.setyMin(double_.getY());
            }
        }
    }

    public double getyMax() {
        return this.yMax;
    }

    public void setyMax(double d) {
        this.yMax = d;
    }

    public double getyMin() {
        return this.yMin;
    }

    public void setyMin(double d) {
        this.yMin = d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(":  xMin= " + super.getMinValue());
        stringBuffer.append(" xMax= " + super.getMaxValue());
        stringBuffer.append("  yMin= " + this.yMin);
        stringBuffer.append(" yMax= " + this.yMax);
        return stringBuffer.toString();
    }
}

