/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;

public class MixedELValueParser {
    private boolean inExpr = false;
    private boolean inLiteral = false;
    private char literalDelimiter = (char)34;
    private StringBuffer sb = new StringBuffer();
    private int currentPosition = 0;
    private String exprString;

    public MixedELValueParser() {
    }

    public MixedELValueParser(String exprString) {
        this.exprString = exprString;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> l = new ArrayList<String>();
        l.add("#{foo}");
        l.add("foo#{foo}bar");
        l.add("foo\\#{foo}");
        l.add("foo#{foo = '#{foo}'}");
        l.add("foo#{foo = '\\'#{foo}'}");
        l.add("foo#{foo = \"\\\"#{foo}\"}");
        l.add("foo's#{bar}");
        l.add("foo#{bar");
        l.add("foo#{bar}#{baz}");
        l.add("foo#{bar}{baz}");
        l.add("foo#{'}'}");
        l.add("foo#{'}'");
        Iterator i = l.iterator();
        block2: while (i.hasNext()) {
            String test = (String)i.next();
            System.out.println("Parsing " + test);
            MixedELValueParser p = new MixedELValueParser(test);
            boolean done = false;
            System.out.println("Result:");
            while (!done) {
                Token t = null;
                try {
                    t = p.getNextToken();
                }
                catch (ElException e) {
                    System.out.println("  Exception: " + e);
                    continue block2;
                }
                if (t == null) {
                    done = true;
                    continue;
                }
                if (t instanceof ExprToken) {
                    System.out.println("  Expression: " + t.getValue());
                    continue;
                }
                System.out.println("  Literal: " + t.getValue());
            }
        }
    }

    public List parse(FacesContext context, String exprString) throws ElException {
        this.exprString = exprString;
        this.inExpr = false;
        this.inLiteral = false;
        this.sb = new StringBuffer();
        this.currentPosition = 0;
        boolean done = false;
        ArrayList<Object> l = new ArrayList<Object>();
        while (!done) {
            Token t = this.getNextToken();
            if (t == null) {
                done = true;
                continue;
            }
            if (t instanceof ExprToken) {
                l.add(MixedELValueParser.toExpression(context, t.getValue()));
                continue;
            }
            l.add(t.getValue());
        }
        return l;
    }

    private Token getNextToken() throws ElException {
        Token t = null;
        int i = this.currentPosition;
        while (i < this.exprString.length()) {
            char c = this.exprString.charAt(i);
            if (!(this.inLiteral || c != '#' || i != 0 && this.exprString.charAt(i - 1) == '\\' || i + 1 >= this.exprString.length() || this.exprString.charAt(i + 1) != '{')) {
                this.inExpr = true;
                ++i;
                if (this.sb.length() > 0) {
                    t = new Token(this.sb.toString());
                    this.sb = new StringBuffer();
                    this.currentPosition = i + 1;
                    return t;
                }
            } else {
                if (!this.inLiteral && this.inExpr && c == '}') {
                    this.inExpr = false;
                    t = new ExprToken(this.sb.toString());
                    this.sb = new StringBuffer();
                    this.currentPosition = i + 1;
                    return t;
                }
                if (this.inExpr && (c == '\'' || c == '\"') && i > 0 && this.exprString.charAt(i - 1) != '\\') {
                    if (this.inLiteral && c == this.literalDelimiter) {
                        this.inLiteral = false;
                    } else if (!this.inLiteral) {
                        this.inLiteral = true;
                        this.literalDelimiter = c;
                    }
                    this.sb.append(c);
                } else {
                    this.sb.append(c);
                }
            }
            ++i;
        }
        if (this.sb.length() > 0) {
            if (this.inExpr) {
                throw new ElException("Missing closing delimiter: " + this.exprString);
            }
            t = new Token(this.sb.toString());
            this.sb = new StringBuffer();
            this.currentPosition = i + 1;
            return t;
        }
        return null;
    }

    private static Expression toExpression(FacesContext context, String exprString) throws ElException {
        Application application = context.getApplication();
        ExpressionInfo info = new ExpressionInfo();
        info.setExpressionString(exprString);
        info.setFacesContext(context);
        info.setVariableResolver(application.getVariableResolver());
        info.setPropertyResolver(application.getPropertyResolver());
        return Util.getExpressionEvaluator().parseExpression(info);
    }

    private static class ExprToken
    extends Token {
        public ExprToken(String value) {
            super(value);
        }
    }

    private static class Token {
        String value;

        public Token(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

