/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.io;

import de.hunsicker.util.ResourceBundleFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;

public class Copy {
    private static final String BUNDLE_NAME = "de.hunsicker.io.Bundle";

    private Copy() {
    }

    public static boolean directory(File source, File destination) throws IOException {
        if (source == null) {
            throw new NullPointerException();
        }
        if (!source.exists()) {
            Object[] args = new Object[]{source};
            throw new IllegalArgumentException(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("NOT_FOUND"), args));
        }
        if (!source.isDirectory()) {
            Object[] args = new Object[]{source};
            throw new IllegalArgumentException(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("NOT_DIRECTORY"), args));
        }
        File[] files = source.listFiles();
        boolean success = true;
        int i = 0;
        while (i < files.length) {
            success = files[i].isFile() ? Copy.file(files[i], new File(destination, files[i].getName())) : Copy.directory(files[i], new File(destination, files[i].getName()));
            if (!success) {
                return false;
            }
            ++i;
        }
        return success;
    }

    public static boolean file(String source, String destination) throws IOException {
        return Copy.file(new File(source), new File(destination), false);
    }

    public static boolean file(File source, File destination) throws IOException {
        return Copy.file(source, destination, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean file(File source, File destination, boolean overwrite) throws IOException {
        if (source == null) {
            throw new NullPointerException();
        }
        if (!source.exists()) {
            Object[] args = new Object[]{source};
            throw new IllegalArgumentException(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("NOT_FOUND"), args));
        }
        if (!source.isFile()) {
            Object[] args = new Object[]{source};
            throw new IllegalArgumentException(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("NOT_FILE"), args));
        }
        if (overwrite || destination.lastModified() < source.lastModified()) {
            File parent = destination.getAbsoluteFile().getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[8192];
            int count = 0;
            try {
                do {
                    ((OutputStream)out).write(buffer, 0, count);
                } while ((count = ((InputStream)in).read(buffer, 0, buffer.length)) != -1);
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            return true;
        }
        return false;
    }
}

