/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.demo.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.PieChartDataSet;
import org.krysalis.jcharts.nonAxisChart.PieChart2D;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PieChart2DProperties;
import org.krysalis.jcharts.properties.PropertyException;

public class SwingDemo
extends JFrame {
    private JPanel panel;
    private PieChart2DProperties pieChart2DProperties;
    private LegendProperties legendProperties;
    private ChartProperties chartProperties;

    public SwingDemo() throws ChartDataException, PropertyException {
        this.initComponents();
    }

    private void initComponents() {
        this.setSize(500, 500);
        this.panel = new JPanel(true);
        this.panel.setSize(500, 500);
        this.getContentPane().add(this.panel);
        this.pieChart2DProperties = new PieChart2DProperties();
        this.legendProperties = new LegendProperties();
        this.chartProperties = new ChartProperties();
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SwingDemo.this.exitForm(windowEvent);
            }
        });
    }

    public void paint(Graphics graphics) {
        try {
            String[] stringArray = new String[]{"BMW", "Audi", "Lexus"};
            String string = "Cars that Own";
            Paint[] paintArray = new Paint[]{Color.blue, Color.gray, Color.red};
            double[] dArray = new double[]{50.0, 30.0, 20.0};
            PieChartDataSet pieChartDataSet = new PieChartDataSet(string, dArray, stringArray, paintArray, this.pieChart2DProperties);
            Dimension dimension = this.panel.getSize();
            PieChart2D pieChart2D = new PieChart2D(pieChartDataSet, this.legendProperties, this.chartProperties, (int)dimension.getWidth(), (int)dimension.getHeight());
            pieChart2D.setGraphics2D((Graphics2D)this.panel.getGraphics());
            pieChart2D.render();
        }
        catch (ChartDataException chartDataException) {
            chartDataException.printStackTrace();
        }
        catch (PropertyException propertyException) {
            propertyException.printStackTrace();
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) throws ChartDataException, PropertyException {
        new SwingDemo();
    }
}

