/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.axisChart.customRenderers.axisValue.AxisValueRenderEvent;
import org.krysalis.jcharts.chartData.interfaces.IAxisChartDataSet;
import org.krysalis.jcharts.chartText.TextTagGroup;
import org.krysalis.jcharts.imageMap.RectMapArea;
import org.krysalis.jcharts.properties.BarChartProperties;

abstract class BarChart {
    BarChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        Graphics2D graphics2D = axisChart.getGraphics2D();
        BarChartProperties barChartProperties = (BarChartProperties)iAxisChartDataSet.getChartTypeProperties();
        if (axisChart.getAxisProperties().isPlotHorizontal()) {
            float f = axisChart.getYAxis().getScalePixelWidth() * barChartProperties.getPercentage();
            float f2 = axisChart.getXAxis().getZeroLineCoordinate();
            float f3 = axisChart.getYAxis().getLastTickY() - f / 2.0f;
            float f4 = 0.0f;
            float f5 = f;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f3, f4, f5);
            BarChart.horizontalPlot(axisChart, iAxisChartDataSet, barChartProperties, graphics2D, float_, f2);
        } else {
            float f = axisChart.getXAxis().getScalePixelWidth() * barChartProperties.getPercentage();
            float f6 = axisChart.getXAxis().getTickStart() - f / 2.0f;
            float f7 = axisChart.getYAxis().getZeroLineCoordinate();
            float f8 = f;
            float f9 = 0.0f;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f6, f7, f8, f9);
            BarChart.verticalPlot(axisChart, iAxisChartDataSet, barChartProperties, graphics2D, float_, f7);
        }
    }

    private static void horizontalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, BarChartProperties barChartProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f) {
        int n = axisChart.getYAxis().getNumberOfScaleItems() - 1;
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        float_2.y = axisChart.getYAxis().getOrigin() - axisChart.getYAxis().getPixelLength() + 1.0f;
        float_2.height = axisChart.getYAxis().getScalePixelWidth() - 1.0f;
        float_2.x = axisChart.getXAxis().getOrigin() + 1.0f;
        float_2.width = axisChart.getXAxis().getPixelLength() - 1.0f;
        AxisValueRenderEvent axisValueRenderEvent = new AxisValueRenderEvent(axisChart, iAxisChartDataSet, graphics2D, float_2, axisChart.getXAxis().getZeroLineCoordinate());
        axisValueRenderEvent.setDataSetIndex(0);
        for (int i = 0; i < iAxisChartDataSet.getNumberOfDataItems(); ++i) {
            RectMapArea rectMapArea;
            graphics2D.setPaint(iAxisChartDataSet.getPaint(0));
            axisValueRenderEvent.setValueX(axisChart.getXAxis().getZeroLineCoordinate());
            axisValueRenderEvent.setValueY((float)float_.getCenterY());
            axisValueRenderEvent.setValueIndex(i);
            barChartProperties.firePreRender(axisValueRenderEvent);
            if (iAxisChartDataSet.getValue(0, i) != 0.0) {
                if (iAxisChartDataSet.getValue(0, i) < 0.0) {
                    float_.x = axisChart.getXAxis().computeAxisCoordinate(axisChart.getXAxis().getOrigin(), iAxisChartDataSet.getValue(0, i), axisChart.getXAxis().getScaleCalculator().getMinValue());
                    float_.width = f - float_.x;
                    axisValueRenderEvent.setValueX(float_.x);
                } else {
                    float_.x = f;
                    float_.width = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(0, i), axisChart.getXAxis().getOneUnitPixelSize());
                    axisValueRenderEvent.setValueX(float_.x + float_.width);
                }
                if (float_.width != 0.0f) {
                    graphics2D.fill(float_);
                    if (barChartProperties.getShowOutlinesFlag()) {
                        barChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                    }
                    if (axisChart.getGenerateImageMapFlag()) {
                        rectMapArea = BarChart.createImageMapArea(axisChart.getYAxis().getAxisLabelsGroup(), n, float_, iAxisChartDataSet.getValue(0, i), iAxisChartDataSet.getLegendLabel(0));
                        axisChart.getImageMap().addImageMapArea(rectMapArea);
                        --n;
                    }
                }
            } else if (axisChart.getGenerateImageMapFlag()) {
                if (axisChart.getXAxis().getScaleCalculator().getMaxValue() >= 0.0 && axisChart.getXAxis().getScaleCalculator().getMinValue() <= 0.0) {
                    float_.x = f;
                    float_.width = 1.0f;
                    rectMapArea = BarChart.createImageMapArea(axisChart.getYAxis().getAxisLabelsGroup(), n, float_, iAxisChartDataSet.getValue(0, i), iAxisChartDataSet.getLegendLabel(0));
                    axisChart.getImageMap().addImageMapArea(rectMapArea);
                }
                --n;
            }
            barChartProperties.firePostRender(axisValueRenderEvent);
            float_2.y += axisChart.getYAxis().getScalePixelWidth();
            float_.y += axisChart.getYAxis().getScalePixelWidth();
        }
    }

    private static void verticalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, BarChartProperties barChartProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f) {
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        float_2.x = axisChart.getXAxis().getOrigin() + 1.0f;
        float_2.y = axisChart.getYAxis().getOrigin() - axisChart.getYAxis().getPixelLength() + 1.0f;
        float_2.width = axisChart.getXAxis().getScalePixelWidth() - 1.0f;
        float_2.height = axisChart.getYAxis().getPixelLength() - 1.0f;
        AxisValueRenderEvent axisValueRenderEvent = new AxisValueRenderEvent(axisChart, iAxisChartDataSet, graphics2D, float_2, axisChart.getYAxis().getZeroLineCoordinate());
        axisValueRenderEvent.setDataSetIndex(0);
        for (int i = 0; i < iAxisChartDataSet.getNumberOfDataItems(); ++i) {
            RectMapArea rectMapArea;
            graphics2D.setPaint(iAxisChartDataSet.getPaint(0));
            axisValueRenderEvent.setValueX((float)float_.getCenterX());
            axisValueRenderEvent.setValueY(axisChart.getYAxis().getZeroLineCoordinate());
            axisValueRenderEvent.setValueIndex(i);
            barChartProperties.firePreRender(axisValueRenderEvent);
            if (iAxisChartDataSet.getValue(0, i) != 0.0) {
                if (iAxisChartDataSet.getValue(0, i) < 0.0) {
                    float_.y = f;
                    float_.height = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(0, i), axisChart.getYAxis().getOneUnitPixelSize());
                    axisValueRenderEvent.setValueY(float_.y + float_.height);
                } else {
                    float_.y = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iAxisChartDataSet.getValue(0, i), axisChart.getYAxis().getScaleCalculator().getMinValue());
                    float_.height = f - float_.y;
                    axisValueRenderEvent.setValueY(float_.y);
                }
                if (float_.height != 0.0f) {
                    graphics2D.fill(float_);
                    if (barChartProperties.getShowOutlinesFlag()) {
                        barChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                        graphics2D.setPaint(iAxisChartDataSet.getPaint(0));
                    }
                }
                if (axisChart.getGenerateImageMapFlag()) {
                    rectMapArea = BarChart.createImageMapArea(axisChart.getXAxis().getAxisLabelsGroup(), i, float_, iAxisChartDataSet.getValue(0, i), iAxisChartDataSet.getLegendLabel(0));
                    axisChart.getImageMap().addImageMapArea(rectMapArea);
                }
            } else if (axisChart.getGenerateImageMapFlag() && axisChart.getYAxis().getScaleCalculator().getMaxValue() >= 0.0 && axisChart.getYAxis().getScaleCalculator().getMinValue() <= 0.0) {
                float_.y = f;
                float_.height = 1.0f;
                rectMapArea = BarChart.createImageMapArea(axisChart.getXAxis().getAxisLabelsGroup(), i, float_, iAxisChartDataSet.getValue(0, i), iAxisChartDataSet.getLegendLabel(0));
                axisChart.getImageMap().addImageMapArea(rectMapArea);
            }
            barChartProperties.firePostRender(axisValueRenderEvent);
            float_2.x += axisChart.getXAxis().getScalePixelWidth();
            float_.x += axisChart.getXAxis().getScalePixelWidth();
        }
    }

    static float computeScaleHeightOfValue(double d, double d2) {
        return (float)Math.abs(d * d2);
    }

    private static RectMapArea createImageMapArea(TextTagGroup textTagGroup, int n, Rectangle2D.Float float_, double d, String string) {
        String string2 = textTagGroup != null ? textTagGroup.getTextTag(n).getText() : "";
        return new RectMapArea(float_, d, string2, string);
    }
}

