/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.acegisecurity.concurrent.SessionIdentifierAware;

public class WebAuthenticationDetails
implements SessionIdentifierAware,
Serializable {
    private String remoteAddress;
    private String sessionId;

    public WebAuthenticationDetails(HttpServletRequest request) {
        this.remoteAddress = request.getRemoteAddr();
        HttpSession session = request.getSession(false);
        this.sessionId = session != null ? session.getId() : null;
        this.doPopulateAdditionalInformation(request);
    }

    protected WebAuthenticationDetails() {
        throw new IllegalArgumentException("Cannot use default constructor");
    }

    protected void doPopulateAdditionalInformation(HttpServletRequest request) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails rhs = (WebAuthenticationDetails)obj;
            if (this.remoteAddress == null && rhs.getRemoteAddress() != null) {
                return false;
            }
            if (this.remoteAddress != null && rhs.getRemoteAddress() == null) {
                return false;
            }
            if (this.remoteAddress != null && !this.remoteAddress.equals(rhs.getRemoteAddress())) {
                return false;
            }
            if (this.sessionId == null && rhs.getSessionId() != null) {
                return false;
            }
            if (this.sessionId != null && rhs.getSessionId() == null) {
                return false;
            }
            return this.sessionId == null || this.sessionId.equals(rhs.getSessionId());
        }
        return false;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int hashCode() {
        int code = 7654;
        if (this.remoteAddress != null) {
            code *= this.remoteAddress.hashCode() % 7;
        }
        if (this.sessionId != null) {
            code *= this.sessionId.hashCode() % 7;
        }
        return code;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString() + ": ");
        sb.append("RemoteIpAddress: " + this.getRemoteAddress() + "; ");
        sb.append("SessionId: " + this.getSessionId());
        return sb.toString();
    }
}

