/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class JavaUtils {
    static final String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final Collator englishCollator = Collator.getInstance(Locale.ENGLISH);
    static final char keywordPrefix = '_';
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private static boolean isPunctuation(char c) {
        return '-' == c || '.' == c || ':' == c || '\u00b7' == c || '\u0387' == c || '-' == c || '\u06dd' == c || '\u06de' == c;
    }

    public static boolean isJavaKeyword(String keyword) {
        if (JavaUtils.hasUpperCase(keyword)) {
            return false;
        }
        return Arrays.binarySearch(keywords, keyword, englishCollator) >= 0;
    }

    public static boolean hasUpperCase(String word) {
        if (word == null) {
            return false;
        }
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(word.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String makeNonJavaKeyword(String keyword) {
        return '_' + keyword;
    }

    public static String xmlNameToJava(String name) {
        int i;
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] nameArray = name.toCharArray();
        int nameLen = name.length();
        StringBuffer result = new StringBuffer(nameLen);
        boolean wordStart = false;
        for (i = 0; i < nameLen && (JavaUtils.isPunctuation(nameArray[i]) || !Character.isJavaIdentifierStart(nameArray[i])); ++i) {
        }
        if (i < nameLen) {
            result.append(nameArray[i]);
            wordStart = !Character.isLetter(nameArray[i]) && nameArray[i] != "_".charAt(0);
        } else if (Character.isJavaIdentifierPart(nameArray[0])) {
            result.append("_").append(nameArray[0]);
        } else {
            result.append("_").append(nameArray.length);
        }
        ++i;
        while (i < nameLen) {
            char c = nameArray[i];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                wordStart = true;
            } else {
                if (wordStart && Character.isLowerCase(c)) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(c);
                }
                wordStart = !Character.isLetter(c) && c != "_".charAt(0);
            }
            ++i;
        }
        String newName = result.toString();
        if (JavaUtils.isJavaKeyword(newName)) {
            newName = JavaUtils.makeNonJavaKeyword(newName);
        }
        return newName;
    }

    public static String capitalizeFirstChar(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char start = name.charAt(0);
        if (Character.isLowerCase(start)) {
            start = Character.toUpperCase(start);
            return start + name.substring(1);
        }
        return name;
    }

    public static String xmlNameToJavaIdentifier(String name) {
        String javaName = JavaUtils.xmlNameToJava(name);
        if (javaName != null && javaName.length() > 0) {
            javaName = javaName.substring(0, 1).toLowerCase() + javaName.substring(1);
        }
        return javaName;
    }

    public static boolean isTrue(String value) {
        return !JavaUtils.isFalseExplicitly(value);
    }

    public static boolean isTrueExplicitly(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("yes"));
    }

    public static boolean isTrueExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        if (value instanceof String) {
            return JavaUtils.isTrueExplicitly((String)value);
        }
        return defaultVal;
    }

    public static boolean isTrueExplicitly(Object value) {
        return JavaUtils.isTrueExplicitly(value, false);
    }

    public static boolean isTrue(Object value, boolean defaultVal) {
        return !JavaUtils.isFalseExplicitly(value, !defaultVal);
    }

    public static boolean isTrue(Object value) {
        return JavaUtils.isTrue(value, false);
    }

    public static boolean isFalse(String value) {
        return JavaUtils.isFalseExplicitly(value);
    }

    public static boolean isFalseExplicitly(String value) {
        return value == null || value.equalsIgnoreCase("false") || value.equals("0") || value.equalsIgnoreCase("no");
    }

    public static boolean isFalseExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Integer) {
            return (Integer)value == 0;
        }
        if (value instanceof String) {
            return JavaUtils.isFalseExplicitly((String)value);
        }
        return false;
    }

    public static boolean isFalseExplicitly(Object value) {
        return JavaUtils.isFalseExplicitly(value, true);
    }

    public static boolean isFalse(Object value, boolean defaultVal) {
        return JavaUtils.isFalseExplicitly(value, defaultVal);
    }

    public static boolean isFalse(Object value) {
        return JavaUtils.isFalse(value, true);
    }

    public static boolean isJavaId(String id) {
        if (id == null || id.length() == 0 || JavaUtils.isJavaKeyword(id)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static Class getWrapperClass(Class primitive) {
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    public static Class getWrapperClass(String primitive) {
        if (primitive.equals("int")) {
            return Integer.class;
        }
        if (primitive.equals("short")) {
            return Short.class;
        }
        if (primitive.equals("boolean")) {
            return Boolean.class;
        }
        if (primitive.equals("byte")) {
            return Byte.class;
        }
        if (primitive.equals("long")) {
            return Long.class;
        }
        if (primitive.equals("double")) {
            return Double.class;
        }
        if (primitive.equals("float")) {
            return Float.class;
        }
        if (primitive.equals("char")) {
            return Character.class;
        }
        return null;
    }

    public static int indexOfIgnoreCase(String string, String search) {
        int index = -1;
        int stringLength = string.length();
        int testLength = search.length();
        if (stringLength > 1 || testLength > 1) {
            char firstCharOfTest = Character.toLowerCase(search.charAt(0));
            int lastStringCharacterToCheck = stringLength - testLength + 1;
            for (int i = 0; i < lastStringCharacterToCheck; ++i) {
                if (firstCharOfTest != Character.toLowerCase(string.charAt(i))) continue;
                index = i;
                for (int j = 1; j < testLength; ++j) {
                    char c = string.charAt(i + j);
                    char otherChar = search.charAt(j);
                    if (Character.toLowerCase(c) == Character.toLowerCase(otherChar)) continue;
                    index = -1;
                    break;
                }
                if (-1 != index) break;
            }
        }
        return index;
    }

    public static final String replace(String name, String oldT, String newT) {
        if (name == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(name.length() * 2);
        int len = oldT.length();
        try {
            int start = 0;
            int i = name.indexOf(oldT, start);
            while (i >= 0) {
                sb.append(name.substring(start, i));
                sb.append(newT);
                start = i + len;
                i = name.indexOf(oldT, start);
            }
            if (start < name.length()) {
                sb.append(name.substring(start));
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return new String(sb);
    }

    public static String callStackToString() {
        return JavaUtils.stackToString(new RuntimeException());
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        text = text.substring(text.indexOf("at"));
        text = JavaUtils.replace(text, "at ", "DEBUG_FRAME = ");
        return text;
    }
}

