/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExecuteQueue {
    private static final int DEFAULT_MAXIMUM_THREAD_POOL_SIZE = 30;
    private static final Log LOG = LogFactory.getLog((Class)ExecuteQueue.class);
    private ThreadPoolExecutor executorService;

    public ExecuteQueue() {
        this(30);
    }

    public ExecuteQueue(int maximumThreadPoolSize) throws IllegalArgumentException {
        if (maximumThreadPoolSize <= 0) {
            throw new IllegalArgumentException("maximumThreadPoolSize <= 0");
        }
        this.executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool((int)maximumThreadPoolSize);
    }

    public void execute(Runnable runnable) {
        block3: {
            if (runnable != null) {
                try {
                    this.executorService.execute(runnable);
                }
                catch (RejectedExecutionException exception) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)"Execution of the runnable rejected!", (Throwable)exception);
                }
            }
        }
    }

    public int getMaximumThreadPoolSize() {
        return this.executorService.getMaximumPoolSize();
    }
}

