/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.env;

import com.icesoft.faces.env.Authorization;
import java.security.Principal;
import java.util.Map;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcegiAuthWrapper
implements Authorization {
    private static final Log Log = LogFactory.getLog((Class)AcegiAuthWrapper.class);
    private final Authentication authentication;

    public AcegiAuthWrapper(Principal principal) {
        this.authentication = (Authentication)principal;
    }

    public boolean isUserInRole(String role) {
        if (null == this.authentication) {
            return false;
        }
        Log.trace((Object)("isUserInRole ROLE: " + role));
        GrantedAuthority[] authorities = this.authentication.getAuthorities();
        if (this.authentication.getPrincipal() == null || authorities == null) {
            return false;
        }
        for (int i = 0; i < authorities.length; ++i) {
            if (!role.equals(authorities[i].getAuthority())) continue;
            return true;
        }
        return false;
    }

    public static Authorization getVerifier(Principal principal, Map sessionMap) {
        if (principal instanceof Authentication) {
            return new AcegiAuthWrapper(principal);
        }
        SecurityContext sc = (SecurityContext)sessionMap.get("ACEGI_SECURITY_CONTEXT");
        return new AcegiAuthWrapper((Principal)(sc == null ? null : sc.getAuthentication()));
    }
}

