/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis2.schema.SchemaConstants;

public class BeanWriterMetaInfoHolder {
    protected boolean ordered = false;
    protected boolean anonymous = false;
    protected boolean choice = false;
    protected boolean simple = false;
    protected boolean extension = false;
    protected boolean restriction = false;
    private String extensionClassName = "";
    private String restrictionClassName = "";
    private QName extensionBaseType = null;
    private QName restrictionBaseType = null;
    protected Map elementToSchemaQNameMap = new LinkedHashMap();
    protected Map elementToJavaClassMap = new LinkedHashMap();
    protected Map specialTypeFlagMap = new LinkedHashMap();
    protected Map qNameMaxOccursCountMap = new LinkedHashMap();
    protected Map qNameMinOccursCountMap = new LinkedHashMap();
    protected Map qNameOrderMap = new LinkedHashMap();
    protected QName ownQname = null;
    protected String ownClassName = null;
    protected long lengthFacet = -1L;
    protected long maxLengthFacet = -1L;
    protected long minLengthFacet = -1L;
    protected ArrayList enumFacet = new ArrayList();
    protected String patternFacet = null;
    protected String maxExclusiveFacet = null;
    protected String minExclusiveFacet = null;
    protected String maxInclusiveFacet = null;
    protected String minInclusiveFacet = null;
    protected Map memberTypes = new HashMap();
    protected Map xmlNameJavaNameMap = new HashMap();
    protected List memberTypesKeys = new ArrayList();
    protected Map elementQNameToDefulatValueMap = new HashMap();
    protected QName itemTypeQName;
    protected String itemTypeClassName;
    protected boolean isUnion;
    protected boolean isList;
    protected boolean isParticleClass;
    protected boolean hasParticleType;
    protected List nillableQNameList = new ArrayList();
    protected BeanWriterMetaInfoHolder parent = null;

    public boolean isChoice() {
        return this.choice;
    }

    public void setChoice(boolean choice) {
        this.choice = choice;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    public String getOwnClassName() {
        return this.ownClassName;
    }

    public void setOwnClassName(String ownClassName) {
        this.ownClassName = ownClassName;
    }

    public QName getOwnQname() {
        return this.ownQname;
    }

    public void setOwnQname(QName ownQname) {
        this.ownQname = ownQname;
    }

    public BeanWriterMetaInfoHolder getParent() {
        return this.parent;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public String getExtensionClassName() {
        return this.extensionClassName;
    }

    public void setExtensionClassName(String extensionClassName) {
        this.extensionClassName = extensionClassName;
    }

    public boolean isExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public String getRestrictionClassName() {
        return this.restrictionClassName;
    }

    public void setRestrictionClassName(String restrictionClassName) {
        this.restrictionClassName = restrictionClassName;
    }

    public boolean isRestriction() {
        return this.restriction;
    }

    public void setRestriction(boolean restriction) {
        this.restriction = restriction;
    }

    public void setExtensionBaseType(QName extensionBaseType) {
        this.extensionBaseType = extensionBaseType;
    }

    public boolean isExtensionBaseType(QName extensionBaseType) {
        return this.extensionBaseType == extensionBaseType;
    }

    public void setRestrictionBaseType(QName restrictionBaseType) {
        this.restrictionBaseType = restrictionBaseType;
    }

    public boolean isRestrictionBaseType(QName restrictionBaseType) {
        QName baseTypeQName = (QName)this.elementToSchemaQNameMap.get(restrictionBaseType);
        return this.restrictionBaseType != null && baseTypeQName != null && this.restrictionBaseType.equals(baseTypeQName);
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void registerMapping(QName qName, QName schemaName, String javaClassName) {
        this.registerMapping(qName, schemaName, javaClassName, 2);
    }

    public void registerNillableQName(QName eltQName) {
        this.nillableQNameList.add(eltQName);
    }

    public boolean isNillable(QName eltQName) {
        return this.nillableQNameList.contains(eltQName);
    }

    public void registerMapping(QName qName, QName schemaName, String javaClassName, int type) {
        this.elementToJavaClassMap.put(qName, javaClassName);
        this.elementToSchemaQNameMap.put(qName, schemaName);
        this.addtStatus(qName, type);
    }

    public void registerDefaultValue(QName qname, String value) {
        this.elementQNameToDefulatValueMap.put(qname, value);
    }

    public boolean isDefaultValueAvailable(QName qname) {
        return this.elementQNameToDefulatValueMap.containsKey(qname);
    }

    public String getDefaultValueForQName(QName qname) {
        return (String)this.elementQNameToDefulatValueMap.get(qname);
    }

    public QName getSchemaQNameForQName(QName eltQName) {
        return (QName)this.elementToSchemaQNameMap.get(eltQName);
    }

    public String getClassNameForQName(QName eltQName) {
        return (String)this.elementToJavaClassMap.get(eltQName);
    }

    public boolean getAttributeStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 1);
    }

    public boolean getDefaultStatusForQName(QName qName) {
        boolean isDefault = false;
        QName schemaTypeQName = (QName)this.elementToSchemaQNameMap.get(qName);
        if (schemaTypeQName != null) {
            isDefault = schemaTypeQName.equals(SchemaConstants.XSD_ANYTYPE);
        }
        return isDefault;
    }

    public boolean getAnyStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 8);
    }

    public boolean getArrayStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 4);
    }

    public boolean getBinaryStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 16);
    }

    public boolean getInnerChoiceStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 128);
    }

    public boolean getSimpleStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 64);
    }

    public boolean getParticleTypeStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 256);
    }

    public boolean getAnyAttributeStatusForQName(QName qName) {
        return this.getArrayStatusForQName(qName) && this.getAnyStatusForQName(qName);
    }

    public boolean getOptionalAttributeStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 32);
    }

    public void clearTables() {
        this.elementToJavaClassMap.clear();
        this.elementToSchemaQNameMap.clear();
        this.elementToSchemaQNameMap.clear();
        this.elementToJavaClassMap.clear();
        this.specialTypeFlagMap.clear();
        this.qNameMaxOccursCountMap.clear();
        this.qNameMinOccursCountMap.clear();
        this.qNameOrderMap.clear();
        this.elementQNameToDefulatValueMap.clear();
    }

    public void addMinOccurs(QName qName, long minOccurs) {
        this.qNameMinOccursCountMap.put(qName, new Long(minOccurs));
    }

    public void registerQNameIndex(QName qName, int index) {
        this.qNameOrderMap.put(new Integer(index), qName);
    }

    public long getMinOccurs(QName qName) {
        Long l = (Long)this.qNameMinOccursCountMap.get(qName);
        return l != null ? l : 1L;
    }

    public long getMaxOccurs(QName qName) {
        Long l = (Long)this.qNameMaxOccursCountMap.get(qName);
        return l != null ? l : 1L;
    }

    public void addMaxOccurs(QName qName, long maxOccurs) {
        this.qNameMaxOccursCountMap.put(qName, new Long(maxOccurs));
    }

    public Iterator getElementQNameIterator() {
        return this.elementToJavaClassMap.keySet().iterator();
    }

    public QName[] getQNameArray() {
        Set keySet = this.elementToJavaClassMap.keySet();
        return keySet.toArray(new QName[keySet.size()]);
    }

    public QName[] getOrderedQNameArray() {
        Set set = this.qNameOrderMap.keySet();
        int count = set.size();
        Object[] keys = set.toArray(new Integer[count]);
        Arrays.sort(keys);
        ArrayList<Object> returnQNames = new ArrayList<Object>();
        for (int i = 0; i < keys.length; ++i) {
            returnQNames.add(this.qNameOrderMap.get(keys[i]));
        }
        QName[] allNames = this.getQNameArray();
        for (int i = 0; i < allNames.length; ++i) {
            if (!this.getAttributeStatusForQName(allNames[i])) continue;
            returnQNames.add(allNames[i]);
        }
        return returnQNames.toArray(new QName[returnQNames.size()]);
    }

    public int getOrderStartPoint() {
        return this.qNameOrderMap.size();
    }

    public void setAsParent(BeanWriterMetaInfoHolder metaInfo) {
        this.parent = metaInfo;
    }

    public void addtStatus(QName type, int mask) {
        Object obj = this.specialTypeFlagMap.get(type);
        if (obj != null) {
            int preValue = (Integer)obj;
            this.specialTypeFlagMap.put(type, new Integer(preValue | mask));
        } else {
            this.specialTypeFlagMap.put(type, new Integer(mask));
        }
    }

    private boolean getStatus(int storedStatus, int mask) {
        return mask == (mask & storedStatus);
    }

    public void setLengthFacet(long lengthFacet) {
        this.lengthFacet = lengthFacet;
    }

    public long getLengthFacet() {
        return this.lengthFacet;
    }

    public void setMaxExclusiveFacet(String maxExclusiveFacet) {
        this.maxExclusiveFacet = maxExclusiveFacet;
    }

    public String getMaxExclusiveFacet() {
        return this.maxExclusiveFacet;
    }

    public void setMinExclusiveFacet(String minExclusiveFacet) {
        this.minExclusiveFacet = minExclusiveFacet;
    }

    public String getMinExclusiveFacet() {
        return this.minExclusiveFacet;
    }

    public void setMaxInclusiveFacet(String maxInclusiveFacet) {
        this.maxInclusiveFacet = maxInclusiveFacet;
    }

    public String getMaxInclusiveFacet() {
        return this.maxInclusiveFacet;
    }

    public void setMinInclusiveFacet(String minInclusiveFacet) {
        this.minInclusiveFacet = minInclusiveFacet;
    }

    public String getMinInclusiveFacet() {
        return this.minInclusiveFacet;
    }

    public void setMaxLengthFacet(long maxLengthFacet) {
        this.maxLengthFacet = maxLengthFacet;
    }

    public long getMaxLengthFacet() {
        return this.maxLengthFacet;
    }

    public void setMinLengthFacet(long minLengthFacet) {
        this.minLengthFacet = minLengthFacet;
    }

    public long getMinLengthFacet() {
        return this.minLengthFacet;
    }

    public void setEnumFacet(ArrayList enumFacet) {
        this.enumFacet = enumFacet;
    }

    public void addEnumFacet(String enumFacet) {
        this.enumFacet.add(enumFacet);
    }

    public List getEnumFacet() {
        return this.enumFacet;
    }

    public void setPatternFacet(String patternFacet) {
        this.patternFacet = patternFacet;
    }

    public String getPatternFacet() {
        return this.patternFacet;
    }

    public boolean isUnion() {
        return this.isUnion;
    }

    public void setUnion(boolean union) {
        this.isUnion = union;
    }

    public Map getMemberTypes() {
        return this.memberTypes;
    }

    public void setMemberTypes(Map memberTypes) {
        this.memberTypes = memberTypes;
    }

    public List getMemberTypesKeys() {
        return this.memberTypesKeys;
    }

    public void setMemberTypesKeys(List memberTypesKeys) {
        this.memberTypesKeys = memberTypesKeys;
    }

    public void addMemberType(QName qname, String className) {
        this.memberTypes.put(qname, className);
        this.memberTypesKeys.add(qname);
    }

    public boolean isList() {
        return this.isList;
    }

    public void setList(boolean list) {
        this.isList = list;
    }

    public QName getItemTypeQName() {
        return this.itemTypeQName;
    }

    public void setItemTypeQName(QName itemTypeQName) {
        this.itemTypeQName = itemTypeQName;
    }

    public String getItemTypeClassName() {
        return this.itemTypeClassName;
    }

    public void setItemTypeClassName(String itemTypeClassName) {
        this.itemTypeClassName = itemTypeClassName;
    }

    public boolean isParticleClass() {
        return this.isParticleClass;
    }

    public void setParticleClass(boolean particleClass) {
        this.isParticleClass = particleClass;
    }

    public boolean isHasParticleType() {
        return this.hasParticleType;
    }

    public void setHasParticleType(boolean hasParticleType) {
        this.hasParticleType = hasParticleType;
    }

    public void addXmlNameJavaNameMapping(String xmlName, String javaName) {
        this.xmlNameJavaNameMap.put(xmlName, javaName);
    }

    public boolean isJavaNameMappingAvailable(String xmlName) {
        return this.xmlNameJavaNameMap.containsKey(xmlName);
    }

    public String getJavaName(String xmlName) {
        return (String)this.xmlNameJavaNameMap.get(xmlName);
    }
}

