/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.securechannel;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.securechannel.ChannelDecisionManager;
import org.acegisecurity.securechannel.ChannelProcessor;
import org.springframework.beans.factory.InitializingBean;

public class ChannelDecisionManagerImpl
implements ChannelDecisionManager,
InitializingBean {
    private List channelProcessors;

    public void afterPropertiesSet() throws Exception {
        this.checkIfValidList(this.channelProcessors);
    }

    private void checkIfValidList(List listToCheck) {
        if (listToCheck == null || listToCheck.size() == 0) {
            throw new IllegalArgumentException("A list of ChannelProcessors is required");
        }
    }

    public void decide(FilterInvocation invocation, ConfigAttributeDefinition config) throws IOException, ServletException {
        Iterator iter = this.channelProcessors.iterator();
        while (iter.hasNext()) {
            ChannelProcessor processor = (ChannelProcessor)iter.next();
            processor.decide(invocation, config);
            if (!invocation.getResponse().isCommitted()) continue;
            break;
        }
    }

    public List getChannelProcessors() {
        return this.channelProcessors;
    }

    public void setChannelProcessors(List newList) {
        this.checkIfValidList(newList);
        Iterator iter = newList.iterator();
        while (iter.hasNext()) {
            Object currentObject = null;
            try {
                currentObject = iter.next();
                ChannelProcessor attemptToCast = (ChannelProcessor)currentObject;
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("ChannelProcessor " + currentObject.getClass().getName() + " must implement ChannelProcessor");
            }
        }
        this.channelProcessors = newList;
    }

    public boolean supports(ConfigAttribute attribute) {
        Iterator iter = this.channelProcessors.iterator();
        while (iter.hasNext()) {
            ChannelProcessor processor = (ChannelProcessor)iter.next();
            if (!processor.supports(attribute)) continue;
            return true;
        }
        return false;
    }
}

