/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaticTimerUtility {
    private static int timerIndex;
    public static Log Log;
    private static int jobId;
    private static int totalTimerCount;
    private static long startTime;
    private static long timerStartTime;
    private static long timerAccumulatedTime;
    private static int timersCompleted;
    private static Method timerMethod;
    private static boolean hiRes;

    public static void newJob(int subJobCount) {
        if (!Log.isTraceEnabled()) {
            return;
        }
        if (subJobCount < 0) {
            throw new IllegalArgumentException("Timer count can't be < 0");
        }
        if (subJobCount == 0) {
            return;
        }
        if (jobId != 0) {
            Log.trace((Object)(" ==> Terminating job: " + jobId + " early, " + timersCompleted + " sub-jobs of " + totalTimerCount + " completed"));
        }
        Log.trace((Object)("============= New Timer Job with: " + subJobCount + " subjobs ==============="));
        jobId = ++timerIndex;
        totalTimerCount = subJobCount;
    }

    public static void startJobTmer() {
        try {
            startTime = (Long)timerMethod.invoke(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        timerAccumulatedTime = 0L;
    }

    public static void startSubjobTimer() {
        try {
            timerStartTime = (Long)timerMethod.invoke(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void subJobTimerComplete() {
        if (!Log.isTraceEnabled()) {
            return;
        }
        timerAccumulatedTime += StaticTimerUtility.getSystemTime() - timerStartTime;
        if (++timersCompleted >= totalTimerCount) {
            float factor = hiRes ? 1.0E9f : 1000.0f;
            Log.trace((Object)(" ==> Timer job: " + jobId + " containing: " + totalTimerCount + " subjobs" + ", elapsed real time: " + (float)(StaticTimerUtility.getSystemTime() - startTime) / factor + " seconds"));
            Log.trace((Object)("   ==> Timer job: " + jobId + " accumulated cpu time: " + (float)timerAccumulatedTime / factor + " seconds"));
            Log.trace((Object)"============================");
            StaticTimerUtility.reset();
        }
    }

    private static void reset() {
        jobId = 0;
        timersCompleted = 0;
        totalTimerCount = 0;
        timerAccumulatedTime = 0L;
        startTime = 0L;
    }

    private static long getSystemTime() {
        try {
            return (Long)timerMethod.invoke(null, null);
        }
        catch (Exception e) {
            return System.currentTimeMillis();
        }
    }

    static {
        Log = LogFactory.getLog((Class)StaticTimerUtility.class);
        try {
            timerMethod = System.class.getMethod("currentTimeMillis", null);
            timerMethod = System.class.getMethod("nanoTime", null);
            hiRes = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

