/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ELUtil;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

public class BeanELResolver
extends ELResolver {
    private boolean isReadOnly;

    public BeanELResolver() {
        this.isReadOnly = false;
    }

    public BeanELResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public Class getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        String sProperty = property.toString();
        BeanInfo info = null;
        Class<?> clazz = base.getClass();
        try {
            info = Introspector.getBeanInfo(clazz);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (info == null) {
            throw new ELException("Cannot find BeanInfo for the bean " + clazz.getName());
        }
        PropertyDescriptor[] pd = info.getPropertyDescriptors();
        for (int i = 0; i < pd.length; ++i) {
            if (!pd[i].getName().equals(sProperty)) continue;
            Method method = BeanELResolver.getMethod(clazz, pd[i].getReadMethod());
            Class<?> type = pd[i].getPropertyType();
            if (method == null || type == null) {
                throw new PropertyNotFoundException("Property '" + sProperty + "' is not readable on type: " + clazz.getName());
            }
            context.setPropertyResolved(true);
            return type;
        }
        throw new PropertyNotFoundException("Property '" + sProperty + "' is not found on type: " + clazz.getName());
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        String sProperty = property.toString();
        BeanInfo info = null;
        Class<?> clazz = base.getClass();
        try {
            info = Introspector.getBeanInfo(clazz);
            if (info == null) {
                throw new ELException("Cannot find BeanInfo for the bean " + clazz.getName());
            }
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            for (int i = 0; i < pd.length; ++i) {
                if (!pd[i].getName().equals(sProperty)) continue;
                Method method = BeanELResolver.getMethod(clazz, pd[i].getReadMethod());
                Class<?> type = pd[i].getPropertyType();
                if (method == null || type == null) {
                    throw new PropertyNotFoundException("Property '" + sProperty + "' is not readable on type: " + clazz.getName());
                }
                Object value = method.invoke(base, new Object[0]);
                context.setPropertyResolved(true);
                return value;
            }
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            throw new ELException(ex);
        }
        throw new PropertyNotFoundException("Property '" + sProperty + "' is not found on type: " + clazz.getName());
    }

    public void setValue(ELContext context, Object base, Object property, Object val) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        if (this.isReadOnly) {
            throw new PropertyNotWritableException();
        }
        String sProperty = property.toString();
        BeanInfo info = null;
        Class<?> clazz = base.getClass();
        Class<?> type = null;
        try {
            info = Introspector.getBeanInfo(clazz);
            if (info == null) {
                throw new ELException("Cannot find BeanInfo for the bean " + clazz.getName());
            }
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            for (int i = 0; i < pd.length; ++i) {
                if (!pd[i].getName().equals(sProperty)) continue;
                Method method = BeanELResolver.getMethod(clazz, pd[i].getWriteMethod());
                type = pd[i].getPropertyType();
                if (method == null) {
                    throw new PropertyNotWritableException("Property '" + sProperty + "' is not writable on type: " + clazz.getName());
                }
                if (type == null) {
                    throw new PropertyNotFoundException();
                }
                method.invoke(base, val);
                context.setPropertyResolved(true);
                return;
            }
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            if (null == val) {
                val = "null";
            }
            Object[] params = new Object[]{sProperty, type.getName(), clazz.getName(), val};
            String message = ELUtil.getExceptionMessageString(context, "setPropertyFailed", params);
            throw new ELException(message, ex);
        }
        throw new PropertyNotFoundException("Property '" + sProperty + "' is not found on type: " + clazz.getName());
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        String sProperty = property.toString();
        BeanInfo info = null;
        Class<?> clazz = base.getClass();
        try {
            info = Introspector.getBeanInfo(clazz);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (info == null) {
            throw new ELException("Cannot find BeanInfo for the bean " + clazz.getName());
        }
        PropertyDescriptor[] pd = info.getPropertyDescriptors();
        for (int i = 0; i < pd.length; ++i) {
            if (!pd[i].getName().equals(sProperty)) continue;
            Method method = BeanELResolver.getMethod(clazz, pd[i].getReadMethod());
            Class<?> type = pd[i].getPropertyType();
            if (method == null || type == null) {
                throw new PropertyNotFoundException("Property '" + sProperty + "' is not readable on type: " + clazz.getName());
            }
            context.setPropertyResolved(true);
            return this.isReadOnly || BeanELResolver.getMethod(clazz, pd[i].getWriteMethod()) == null;
        }
        throw new PropertyNotFoundException("Property '" + sProperty + "' is not found on type: " + clazz.getName());
    }

    public Iterator getFeatureDescriptors(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(base.getClass());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (info == null) {
            return null;
        }
        PropertyDescriptor[] pd = info.getPropertyDescriptors();
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(pd.length);
        for (int i = 0; i < pd.length; ++i) {
            pd[i].setValue("type", pd[i].getPropertyType());
            pd[i].setValue("resolvableAtDesignTime", Boolean.TRUE);
            list.add(pd[i]);
        }
        return list.iterator();
    }

    public Class getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    private static Method getMethod(Class cl, Method method) {
        if (Modifier.isPublic(cl.getModifiers())) {
            return method;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> c = interfaces[i];
            Method m = null;
            try {
                m = c.getMethod(method.getName(), method.getParameterTypes());
                c = m.getDeclaringClass();
                m = BeanELResolver.getMethod(c, m);
                if (m == null) continue;
                return m;
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        Class<Object> c = cl.getSuperclass();
        if (c != null) {
            Method m = null;
            try {
                m = c.getMethod(method.getName(), method.getParameterTypes());
                c = m.getDeclaringClass();
                m = BeanELResolver.getMethod(c, m);
                if (m != null) {
                    return m;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        return null;
    }
}

