/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.runas;

import java.util.Iterator;
import java.util.Vector;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.RunAsManager;
import org.springframework.security.runas.RunAsUserToken;
import org.springframework.util.Assert;

public class RunAsManagerImpl
implements RunAsManager,
InitializingBean {
    private String key;
    private String rolePrefix = "ROLE_";

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.key, (String)"A Key is required and should match that configured for the RunAsImplAuthenticationProvider");
    }

    public Authentication buildRunAs(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        Vector<GrantedAuthority> newAuthorities = new Vector<GrantedAuthority>();
        Iterator iter = config.getConfigAttributes().iterator();
        while (iter.hasNext()) {
            ConfigAttribute attribute = (ConfigAttribute)iter.next();
            if (!this.supports(attribute)) continue;
            GrantedAuthorityImpl extraAuthority = new GrantedAuthorityImpl(this.getRolePrefix() + attribute.getAttribute());
            newAuthorities.add(extraAuthority);
        }
        if (newAuthorities.size() == 0) {
            return null;
        }
        for (int i = 0; i < authentication.getAuthorities().length; ++i) {
            newAuthorities.add(authentication.getAuthorities()[i]);
        }
        GrantedAuthority[] resultType = new GrantedAuthority[]{new GrantedAuthorityImpl("holder")};
        GrantedAuthority[] newAuthoritiesAsArray = newAuthorities.toArray(resultType);
        return new RunAsUserToken(this.key, authentication.getPrincipal(), authentication.getCredentials(), newAuthoritiesAsArray, authentication.getClass());
    }

    public String getKey() {
        return this.key;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().startsWith("RUN_AS_");
    }

    public boolean supports(Class clazz) {
        return true;
    }
}

