/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.env;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;

public abstract class CommonEnvironmentRequest {
    protected String authType;
    protected String remoteUser;
    protected Principal userPrincipal;
    protected String requestedSessionId;
    protected boolean requestedSessionIdValid;
    protected String scheme;
    protected String serverName;
    protected int serverPort;
    protected boolean secure;
    protected String contextPath;
    protected Map attributes;
    protected Map parameters;

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getParameter(String name) {
        Object value = this.parameters.get(name);
        if (value instanceof String[]) {
            return ((String[])value)[0];
        }
        return (String)value;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setAttribute(String name, Object value) {
        if (null == value) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        Enumeration locales = this.getLocales();
        return locales.hasMoreElements() ? (Locale)locales.nextElement() : Locale.getDefault();
    }

    public abstract Enumeration getLocales();

    public boolean isSecure() {
        return this.secure;
    }
}

