/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.seteventphase;

import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class SetEventPhase
extends UIComponentBase {
    public static final String COMPONENT_FAMILY = "com.icesoft.faces.SetEventPhase";
    private static Map phaseName2PhaseId = new HashMap();
    private String events;
    private String phase;
    private Boolean disabled;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void queueEvent(FacesEvent event) {
        if (!this.isDisabled() && this.eventMatchingType(event)) {
            this.changePhaseId(event);
        }
        super.queueEvent(event);
    }

    protected boolean eventMatchingType(FacesEvent event) {
        String events = this.getEvents();
        if (events == null || events.length() == 0) {
            return false;
        }
        String[] specifiedEvents = events.split("\\s");
        if (specifiedEvents.length > 0) {
            for (int i = 0; i < specifiedEvents.length; ++i) {
                Class<?> specifiedClass;
                block7: {
                    specifiedClass = null;
                    try {
                        specifiedClass = Class.forName(specifiedEvents[i]);
                    }
                    catch (Exception directName) {
                        if (specifiedEvents[i].indexOf(".") >= 0) break block7;
                        try {
                            specifiedClass = Class.forName("javax.faces.event." + specifiedEvents[i]);
                        }
                        catch (Exception shortName) {
                            throw new FacesException("Could not resolve event class type: " + specifiedEvents[i], (Throwable)directName);
                        }
                    }
                }
                if (specifiedClass == null || !specifiedClass.isInstance(event)) continue;
                return true;
            }
        }
        return false;
    }

    protected void changePhaseId(FacesEvent event) {
        String phase = this.getPhase();
        if (phase == null || phase.trim().length() == 0) {
            return;
        }
        PhaseId phaseId = (PhaseId)phaseName2PhaseId.get(phase);
        if (phaseId == null) {
            throw new FacesException("Could not resolve phase: " + phase);
        }
        event.setPhaseId(phaseId);
    }

    public void setEvents(String events) {
        this.events = events;
    }

    public String getEvents() {
        if (this.events != null) {
            return this.events;
        }
        ValueBinding vb = this.getValueBinding("events");
        return vb != null ? vb.getValue(this.getFacesContext()).toString() : null;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getPhase() {
        if (this.phase != null) {
            return this.phase;
        }
        ValueBinding vb = this.getValueBinding("phase");
        return vb != null ? vb.getValue(this.getFacesContext()).toString() : null;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isDisabled() {
        Boolean val;
        if (null != this.disabled) {
            return this.disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        if (vb != null && (val = (Boolean)vb.getValue(FacesContext.getCurrentInstance())) != null) {
            return val;
        }
        return false;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.events, this.phase, this.disabled};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.events = (String)values[1];
        this.phase = (String)values[2];
        this.disabled = (Boolean)values[3];
    }

    static {
        phaseName2PhaseId.put("ANY", PhaseId.ANY_PHASE);
        phaseName2PhaseId.put("APPLY_REQUEST_VALUES", PhaseId.APPLY_REQUEST_VALUES);
        phaseName2PhaseId.put("PROCESS_VALIDATIONS", PhaseId.PROCESS_VALIDATIONS);
        phaseName2PhaseId.put("UPDATE_MODEL_VALUES", PhaseId.UPDATE_MODEL_VALUES);
        phaseName2PhaseId.put("INVOKE_APPLICATION", PhaseId.INVOKE_APPLICATION);
    }
}

