package de.dass_it.vanhelsing.gui;


import java.lang.reflect.Method;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import de.dass_it.vanhelsing.gui.items.*;
import de.dass_it.www.vanhelsing.*;
import de.dass_it.www.vanhelsing.VanHelsingCallbackHandler.*;
import de.dass_it.www.vanhelsing.VanHelsingStub.*;
/*
 * List all Bacula configuration components by name
 */
public class ConfigurationBean extends TreeNavigation {

	private DefaultTreeModel tree;

	public ConfigurationBean(){
		DefaultMutableTreeNode root = new DefaultMutableTreeNode();
		DefaultMutableTreeNode header;
		String type;
		ListResourcesType lrt;
		DefaultMutableTreeNode myNode;
		ResourceInfo[] ri;
		Client c = new Client();
		String[] nodes = {"Director", "Client", "FileSet", "Schedule",
					"SDStorage", "Catalog", "SDDevice", "Job", "JobDefs"};
		setTree(super.createTree(root, nodes, "Configuration"));

		//\forall header wird eine ResourceList[] angefragt
		for(int i = 0; i < tree.getChildCount(root); i++){
			header = (DefaultMutableTreeNode)tree.getChild(root, i);
			type = ((UserObjectItemType)header.getUserObject()).getUserObject().getResType();
			lrt = new ListResourcesType();
			lrt.setDirector("bacula-dir");
			lrt.setResourceType(type);
			ri = c.getListResources(lrt);
			if (ri.length == 0) continue;
			for (int j = 0; j < ri.length; j++){
				myNode = null;
				myNode = addNode(header, type, ri[j]);
				if (myNode != null){
					header.add(myNode);
				}
			}
		}
	}
	
	public void setTree(DefaultTreeModel tree) {
		this.tree = tree;
	}
	public DefaultTreeModel getTree() {
		return tree;
	}
	
	
}
