package de.dass_it.vanhelsing.gui;

import de.dass_it.www.vanhelsing.*;
import de.dass_it.www.vanhelsing.VanHelsingCallbackHandler.*;
import de.dass_it.www.vanhelsing.VanHelsingStub.*;

public class Client {
	public ResourceInfo[] getListResources(String director, String resource){
		ListResourcesType lrt = new ListResourcesType();
		lrt.setDirector(director);
		lrt.setResourceType(resource);
		return getListResources(lrt);
	}
	public ResourceInfo[] getListResources(ListResourcesType lrt){
		VanHelsingStub stub;
		try {
									 
			stub = getStub();
			
			VanHelsingStub.ListResources req = new VanHelsingStub.ListResources();
			req.setListResources(lrt);
			
			VanHelsingStub.ListResourcesResponse res = stub.listResources(req);
			return (res.getListResourcesResponse()).getResource();
			
		} catch (Exception e){
			System.err.println("getListResources: " + e.toString());
		}
		return new ResourceInfo[0];
	}
	
	public SimpleResource getSimpleResource(String director, int resId){
		GetResourceType grt = new GetResourceType();
		grt.setDirector(director);
		grt.setResId(resId);
		return getSimpleResource(grt);
	}
	public SimpleResource getSimpleResource(GetResourceType grt){
		VanHelsingStub stub;
		try {
			stub = getStub();
			
			VanHelsingStub.GetSimpleResource req = new VanHelsingStub.GetSimpleResource();
			req.setGetSimpleResource(grt);
			
			VanHelsingStub.GetSimpleResourceResponse res = stub.getSimpleResource(req);
			
			SimpleResource sr = new SimpleResource();
			sr.setResourceInfo(res.getResInfo());
			sr.setResourceAttributeType(res.getResAttribute());
			return sr;
			
			
		} catch(Exception e){
			System.err.println("getSR:" + grt.getResId() + ":" + e.toString());
		}
		return new SimpleResource(new ResourceInfo(), new ResourceAttributeType[0]);
	}
	public SetSimpleResourceResponse setSimpleResource(){
		ResourceInitialization ri = new ResourceInitialization();
		return setSimpleResource(ri);
	}
	public SetSimpleResourceResponse setSimpleResource(ResourceInitialization ri){
		VanHelsingStub stub;
		try {
			stub = getStub();
			
			VanHelsingStub.SetSimpleResource req = new VanHelsingStub.SetSimpleResource();
			req.setSetSimpleResource(ri);
			
			VanHelsingStub.SetSimpleResourceResponse res = stub.setSimpleResource(req);
			
			return res;
		} catch (SetSimpleResourceFault1Exception ef1){
			System.err.println("Constraint Violation");
		} catch (SetSimpleResourceFaultException ef){
			System.err.println("Syntax Error");
		} catch (Exception e) {
			System.err.println(e.toString());
		}
		return null;
	}
	
	private VanHelsingStub getStub() throws Exception {
		String url = new String("http://localhost:8080/");
		VanHelsingStub stub = new VanHelsingStub(url);
		stub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.CHUNKED, Boolean.FALSE);
		return stub;
	}	
	public static void main(String args[]){
		Client c = new Client();
		ListResourcesType lrt = new ListResourcesType();
		lrt.setDirector("bacula-dir");
		lrt.setResourceType("JobDefs");
		
		ResourceInfo[] rinfo = c.getListResources(lrt);
	
		System.err.println("!!!rinfo!!!");
		for (int i = 0; i < rinfo.length && rinfo.length > 0; i++){
			System.err.println(rinfo[i].getDirector());
			System.err.println(rinfo[i].getResId());
			System.err.println(rinfo[i].getResName());
			System.err.println(rinfo[i].getResType());
		}
		
		GetResourceType grt = new GetResourceType();
		grt.setDirector("bacula-dir");
		grt.setResId(117);
		
		SimpleResource sr = new SimpleResource();
		sr = c.getSimpleResource(grt);
		
		System.err.println("!!sr!!");
		System.err.println(sr.getResourceInfo().getDirector());
		System.err.println(sr.getResourceInfo().getResId());
		System.err.println(sr.getResourceInfo().getResName());
		System.err.println(sr.getResourceInfo().getResType());

		for (int i = 0; i < sr.getResourceAttributeType().length; i++){
			System.err.print("\nKey:   ");
			System.err.print((sr.getResourceAttributeType())[i].getKey());
			System.err.print("\nValue: ");
			System.err.print((sr.getResourceAttributeType())[i].getValue());
		}
		
	}

}
