package de.dass_it.vanhelsing.gui;

import javax.faces.model.SelectItem;
import de.dass_it.vanhelsing.gui.items.ItemType;
import de.dass_it.vanhelsing.gui.items.UserObjectItem;

public class ViewItem extends ItemType implements UserObjectItem {
	/**
	 * @uml.property  name="key"
	 */
	private String key;
	/**
	 * @uml.property  name="keyValue"
	 */
	private String keyValue;
	/**
	 * @uml.property  name="inputText"
	 */
	private String inputText;
	/**
	 * @uml.property  name="selectOneMenu"
	 */
	private String selectOneMenu;
	/**
	 * @uml.property  name="radioGroup"
	 */
	private String radioGroup;
	/**
	 * @uml.property  name="required"
	 */
	private boolean required;
	/**
	 * @uml.property  name="renderer"
	 */
	private String renderer;
	/**
	 * @uml.property  name="dataType"
	 */
	private String dataType;
	/**
	 * @uml.property  name="keyValueList"
	 * @uml.associationEnd  multiplicity="(0 -1)"
	 */
	private SelectItem[] keyValueList;
	
	public ViewItem(){
		inputText = null;
		selectOneMenu = null;
	}
	
	/**
	 * @return
	 * @uml.property  name="required"
	 */
	public boolean getRequired() {
		return required;
	}

	/**
	 * @param necessary
	 * @uml.property  name="required"
	 */
	public void setRequired(boolean required) {
		this.required = required;
	}

	/**
	 * @return
	 * @uml.property  name="renderer"
	 */
	public String getRenderer() {
		return renderer;
	}

	/**
	 * @param renderer
	 * @uml.property  name="renderer"
	 */
	public void setRenderer(String renderer) {
		this.renderer = renderer;
	}

	/**
	 * @return
	 * @uml.property  name="dataType"
	 */
	public String getDataType() {
		return dataType;
	}

	/**
	 * @param dataType
	 * @uml.property  name="dataType"
	 */
	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	
	//Methoden aus ItemType für die Zuordnung von Änderungen
	public int getResId(){
		return super.getResId();
	}
	public void setResId(int id){
		super.setResId(id);
	}
	public String getResType(){
		return super.getResType();
	}
	public void setResType(String resType){
		super.setResType(resType);
	}
	//eigene Felder für die Tabellenspalten
	/**
	 * @param key
	 * @uml.property  name="key"
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * @return
	 * @uml.property  name="key"
	 */
	public String getKey() {
		return key;
	}
	
	/**
	 * @return
	 * @uml.property  name="keyValue"
	 */
	public String getKeyValue() {
		return keyValue;
	}

	/**
	 * @param keyValue
	 * @uml.property  name="keyValue"
	 */
	public void setKeyValue(String keyValue) {
		this.keyValue = keyValue;
	}

	/**
	 * @param inputText
	 * @uml.property  name="inputText"
	 */
	public void setInputText(String inputText) {
		this.inputText = inputText;
	}

	/**
	 * @return
	 * @uml.property  name="inputText"
	 */
	public String getInputText() {
		return inputText;
	}

	/**
	 * @param selectOneMenu
	 * @uml.property  name="selectOneMenu"
	 */
	public void setSelectOneMenu(String selectOneMenu) {
		this.selectOneMenu = selectOneMenu;
	}

	/**
	 * @return
	 * @uml.property  name="selectOneMenu"
	 */
	public String getSelectOneMenu() {
		return selectOneMenu;
	}
	

	public void setRendererFlag(String r){
		if (r.equals("inputText")) {
			this.inputText = new String("bernd");
			this.selectOneMenu = null;
			this.radioGroup = null;
		}
		if (r.equals("selectOneMenu")){
			this.selectOneMenu = new String("bernd"); //null;
			this.inputText = null; //new String ("bernd");
			this.radioGroup = null;
			//KeyValuesList erzeugen
			/*keyValueList = new SelectItem[3];
			* keyValueList[0] = new SelectItem("keyBernd","valueBernd");
			* keyValueList[1] = new SelectItem("keyHorst","valueHorst");
			* keyValueList[2] = new SelectItem("keyPeter","valuePeter");
			*/	
			
		}
		if (r.equals("radioGroup")){
			this.radioGroup = new String("bernd");
			this.selectOneMenu = null;
			this.inputText = null;
		}
	}

	/**
	 * @return
	 * @uml.property  name="keyValueList"
	 */
	public SelectItem[] getKeyValueList() {
		return keyValueList;
	}

	/**
	 * @param keyValueList
	 * @uml.property  name="keyValueList"
	 */
	public void setKeyValueList(SelectItem[] keyValueList) {
		this.keyValueList = keyValueList;
	}
}
