package de.dass_it.vanhelsing.gui;

import javax.faces.event.ActionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import de.dass_it.www.vanhelsing.VanHelsingStub.*;
import de.dass_it.vanhelsing.gui.items.ConcreteUserObjectItem;
import javax.faces.context.FacesContext;

/**
 * JobSchedule will list all schedules and the jobs which are associated 
 * with a given schedule.
 */
public class JobScheduleBean implements IViewBean {
	private DataTree dataTree;
	private ConcreteUserObjectItem selectedObject;
	public JobScheduleBean(){
		init();
	}
	/**
	 * creates a data tree for the job / schedule view
	 */
	private void init(){
		Client c = new Client();
		UserObjectItemFactory UOFactory = new UserObjectItemFactory();
		ResourceInfo riSched[];
		ResourceInfo riJobs[];
		SimpleResource sr;
		DefaultMutableTreeNode parent;
		dataTree = new DataTree();
		dataTree.setTree("JobSchedule");
		riSched = c.getListResources(BeanUtil.getProperty("defaultdirector"), "Schedule");
		for (ResourceInfo rinfo : riSched){
			parent = dataTree.createNode(dataTree.getRoot(), 
					UOFactory.createUserObjectItem(rinfo));
			riJobs = c.getListResources(rinfo.getDirector(), "Job");
			for (ResourceInfo rJobs : riJobs){
				sr = c.getSimpleResource(rJobs.getDirector(), rJobs.getResId());
				for (ResourceAttributeType rat : sr.getResourceAttributeType()){
					if (rat.getKey().toLowerCase().equals("schedule") &&
						rat.getValue().equals(rinfo.getResName())){	
						dataTree.createNode(parent, 
								UOFactory.createUserObjectItem(rJobs));
					}
				}
			}
		}
	}
	
	/**
	 * creates a new node in the data tree
	 * @param ae	ActionEvent parameter as required by JSF. Not used by this method
	 */
	public void createNodeButtonListener(ActionEvent ae){
		//Methode kann nur mit ausgewählten ParentNode ausgeführt werden
		DefaultMutableTreeNode parent = dataTree.getNodeByName("horst");
		UserObjectItemFactory UOFactory = new UserObjectItemFactory();
		
	}
	/**
	 * updates the selected node of the data tree
	 * @param ae	ActionEvent parameter as required by JSF. Not used by this method
	 */
	public void updateNodeButtonListener(ActionEvent ae){
		BeanUtil.setInfoMessage(null, "Die Methode ist noch nicht implementiert");
		
	}
	/**
	 * delete the selected node of the data tree
	 * @param ae
	 */
	public void deleteNodeButtonListener(ActionEvent ae){
		DefaultMutableTreeNode node;
		ae.getComponent().getAttributes();

		String idString = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("UserObject.resId");
		String name = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("UserObject.resName");
		
		if (idString == null && name != null && !name.equals("")){
			node = dataTree.getNodeByName(name);
			try{
				node = dataTree.deleteNode(node);
			}catch (ConstraintViolationException ecv){
				System.err.println(ecv.toString());
			}
		} else if (idString != null) {
			node = dataTree.getNodeById(new Integer(idString).intValue());
			try {
				node = dataTree.deleteNode(node);
			} catch (ConstraintViolationException ecv) {
				ecv.printStackTrace();
			}
		} else {
			BeanUtil.setInfoMessage(null, "Knoten kann nicht referenziert werden");
		}
		dataTree.getTree().reload();
	}
	/**
	 * rebuilds the data tree
	 * @param ae	ActionEvent parameter as required by JSF. Not used by this method
	 */
	public void readNodeButtonListener(ActionEvent ae){
		init();
	}
	public void selectNode(ActionEvent ae){
		//BeanUtil.setInfoMessage(null, "Die Methode ist noch nicht implementiert");
		String id = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("userObject.resId");
		String name = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("userObject.resName");
		BeanUtil.setInfoMessage(null, ("id: "+id+" name: "+name) );
		
		
	}
	/**
	 * getter method for the dataTree attribute
	 * @return dataTree		returns the dataTree object. If you want to user Javas tree methods directly
	 */
	public DataTree getDataTree(){
		return dataTree;
	}
	/**
	 * setter method for the dataTree attribute.
	 * @param dataTree	the new dataTree object
	 */
	public void setDataTree(DataTree dataTree){
		this.dataTree = dataTree;
	}
}
