/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart.axis;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.lang.reflect.Field;
import java.util.Iterator;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.axisChart.axis.Axis;
import org.krysalis.jcharts.chartData.interfaces.IAxisDataSeries;
import org.krysalis.jcharts.chartData.interfaces.IAxisPlotDataSet;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.AxisTypeProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.test.HTMLTestable;
import org.krysalis.jcharts.types.ChartType;

public class XAxis
extends Axis
implements HTMLTestable {
    private int xLabelFilter = 1;
    private boolean startTicksAtAxis;

    public XAxis(AxisChart axisChart, int n) {
        super(axisChart, n);
    }

    public void computeMinimumHeightNeeded(String string) {
        float f = 0.0f;
        AxisProperties axisProperties = super.getAxisChart().getAxisProperties();
        AxisTypeProperties axisTypeProperties = axisProperties.getXAxisProperties();
        if (axisTypeProperties.showAxisLabels()) {
            if (axisProperties.xAxisLabelsAreVertical()) {
                f = super.getAxisLabelsGroup().getWidestLabel();
            } else {
                f = super.getAxisLabelsGroup().getTallestLabel();
                f += 3.0f;
            }
        }
        if (axisTypeProperties.getShowTicks() != 0) {
            if (axisTypeProperties.showAxisLabels()) {
                f += axisTypeProperties.getPaddingBetweenLabelsAndTicks();
            }
            f += axisTypeProperties.getAxisTickMarkPixelLength();
        } else {
            f += axisTypeProperties.getPaddingBetweenAxisAndLabels();
        }
        if (string != null) {
            super.computeAxisTitleDimensions(string, axisTypeProperties.getTitleChartFont());
            f += super.getTitleHeight();
            f += axisTypeProperties.getPaddingBetweenAxisTitleAndLabels();
        }
        super.setMinimumHeightNeeded(f);
    }

    private void renderAxisTitle(String string, Graphics2D graphics2D, AxisTypeProperties axisTypeProperties) {
        if (string != null) {
            float f = super.getAxisChart().getYAxis().getOrigin() + this.getMinimumHeightNeeded() - super.getTitleHeight();
            float f2 = super.getTitleWidth() > super.getPixelLength() ? ((float)super.getAxisChart().getImageWidth() - super.getTitleWidth()) / 2.0f : super.getOrigin() + (super.getPixelLength() - super.getTitleWidth()) / 2.0f;
            axisTypeProperties.getAxisTitleChartFont().setupGraphics2D(graphics2D);
            graphics2D.drawString(string, f2, f);
        }
    }

    public void computeShouldTickStartAtYAxis(IAxisDataSeries iAxisDataSeries, AxisTypeProperties axisTypeProperties) {
        if (axisTypeProperties instanceof DataAxisProperties) {
            this.startTicksAtAxis = true;
        } else {
            this.startTicksAtAxis = true;
            Iterator iterator = iAxisDataSeries.getIAxisPlotDataSetIterator();
            while (iterator.hasNext()) {
                IAxisPlotDataSet iAxisPlotDataSet = (IAxisPlotDataSet)iterator.next();
                if (!iAxisPlotDataSet.getChartType().equals(ChartType.BAR) && !iAxisPlotDataSet.getChartType().equals(ChartType.BAR_CLUSTERED) && !iAxisPlotDataSet.getChartType().equals(ChartType.BAR_STACKED) && !iAxisPlotDataSet.getChartType().equals(ChartType.LINE) && !iAxisPlotDataSet.getChartType().equals(ChartType.POINT) && !iAxisPlotDataSet.getChartType().equals(ChartType.STOCK)) continue;
                this.startTicksAtAxis = false;
                break;
            }
        }
    }

    public void computeTickStart() {
        float f = super.getOrigin();
        if (!this.startTicksAtAxis) {
            f += super.getScalePixelWidth() / 2.0f;
        }
        super.setTickStart(f);
    }

    public void computeScalePixelWidth(AxisTypeProperties axisTypeProperties) {
        if (this.startTicksAtAxis) {
            super.computeScalePixelWidthDataAxis(axisTypeProperties);
        } else {
            super.setScalePixelWidth(this.getPixelLength() / (float)this.getNumberOfScaleItems());
        }
    }

    public void render(Graphics2D graphics2D, AxisProperties axisProperties, String string) {
        DataAxisProperties dataAxisProperties;
        AxisTypeProperties axisTypeProperties = axisProperties.getXAxisProperties();
        this.renderAxisTitle(string, graphics2D, axisTypeProperties);
        Line2D.Float float_ = new Line2D.Float(super.getTickStart(), 0.0f, super.getTickStart(), 0.0f);
        float f = super.getAxisChart().getYAxis().getOrigin();
        float f2 = super.getAxisChart().getYAxis().getOrigin() + axisTypeProperties.getAxisTickMarkPixelLength();
        float f3 = super.getAxisChart().getYAxis().getOrigin();
        float f4 = super.getAxisChart().getYAxis().getOrigin() - super.getAxisChart().getYAxis().getPixelLength();
        float f5 = super.getTickStart();
        float f6 = super.getAxisChart().getYAxis().getOrigin();
        f6 = axisTypeProperties.getShowTicks() != 0 ? (f6 += axisTypeProperties.getAxisTickMarkPixelLength() + axisTypeProperties.getPaddingBetweenLabelsAndTicks()) : (f6 += axisTypeProperties.getPaddingBetweenAxisAndLabels());
        if (axisTypeProperties.showAxisLabels()) {
            if (!axisProperties.xAxisLabelsAreVertical()) {
                f6 += super.getAxisLabelsGroup().getTallestLabel();
                graphics2D.setFont(axisTypeProperties.getScaleChartFont().getFont());
            } else {
                f5 -= super.getAxisLabelsGroup().getTextTag(0).getFontDescent();
                graphics2D.setFont(axisTypeProperties.getScaleChartFont().deriveFont());
            }
        }
        for (int i = 0; i < super.getNumberOfScaleItems(); ++i) {
            if (axisTypeProperties.getShowGridLines() != 0 && (i == 0 && !(axisTypeProperties instanceof DataAxisProperties) || i > 0 && (axisTypeProperties.getShowGridLines() == 1 || axisTypeProperties.getShowGridLines() == 2 && i % this.xLabelFilter == 0))) {
                float_.y1 = f3;
                float_.y2 = f4;
                if (i < super.getAxisLabelsGroup().size() || i == super.getAxisLabelsGroup().size() && !axisTypeProperties.getShowEndBorder()) {
                    axisTypeProperties.getGridLineChartStroke().draw(graphics2D, float_);
                }
            }
            if (i != super.getNumberOfScaleItems() && (axisTypeProperties.getShowTicks() == 1 || axisTypeProperties.getShowTicks() == 2 && i % this.xLabelFilter == 0)) {
                float_.y1 = f;
                float_.y2 = f2;
                axisTypeProperties.getTickChartStroke().setupGraphics2D(graphics2D);
                graphics2D.draw(float_);
            }
            float_.x1 += super.getScalePixelWidth();
            float_.x2 = float_.x1;
            if (axisTypeProperties.showAxisLabels() && i % this.xLabelFilter == 0) {
                float f7;
                graphics2D.setPaint(axisTypeProperties.getScaleChartFont().getPaint());
                if (!axisProperties.xAxisLabelsAreVertical()) {
                    f7 = f5 - super.getAxisLabelsGroup().getTextTag(i).getWidth() / 2.0f;
                    if (f7 + super.getAxisLabelsGroup().getTextTag(i).getWidth() < (float)super.getAxisChart().getImageWidth()) {
                        super.getAxisLabelsGroup().getTextTag(i).render(graphics2D, f7, f6);
                    }
                } else {
                    f7 = f5 + super.getAxisLabelsGroup().getTextTag(i).getHeight() / 2.0f;
                    if (f7 + super.getAxisLabelsGroup().getTextTag(i).getHeight() < (float)super.getAxisChart().getImageWidth()) {
                        graphics2D.drawString(super.getAxisLabelsGroup().getTextTag(i).getText(), f7, f6 + super.getAxisLabelsGroup().getTextTag(i).getWidth());
                    }
                }
            }
            f5 += super.getScalePixelWidth();
        }
        if (axisTypeProperties.getShowEndBorder()) {
            float_.x2 = float_.x1 = super.getOrigin() + super.getPixelLength();
            float_.y1 = f3;
            float_.y2 = f4;
            axisProperties.getYAxisProperties().getAxisStroke().draw(graphics2D, float_);
        }
        float_.x1 = super.getOrigin();
        float_.x2 = super.getOrigin() + super.getPixelLength();
        float_.y2 = float_.y1 = super.getAxisChart().getYAxis().getOrigin();
        axisTypeProperties.getAxisStroke().setupGraphics2D(graphics2D);
        graphics2D.draw(float_);
        if (axisTypeProperties instanceof DataAxisProperties && (dataAxisProperties = (DataAxisProperties)axisTypeProperties).showZeroLine() && super.getScaleCalculator().getMinValue() < 0.0 && super.getScaleCalculator().getMaxValue() > 0.0) {
            float_.x2 = float_.x1 = super.getZeroLineCoordinate();
            float_.y1 = super.getAxisChart().getYAxis().getOrigin();
            float_.y2 = super.getAxisChart().getYAxis().getOrigin() - super.getAxisChart().getYAxis().getPixelLength();
            dataAxisProperties.getZeroLineChartStroke().draw(graphics2D, float_);
        }
    }

    public void computeLabelFilter() {
        if (super.getAxisChart().getAxisProperties().getXAxisProperties().showAxisLabels()) {
            AxisTypeProperties axisTypeProperties = super.getAxisChart().getAxisProperties().getXAxisProperties();
            float f = super.getAxisChart().getAxisProperties().xAxisLabelsAreVertical() ? super.getAxisLabelsGroup().getTallestLabel() : super.getAxisLabelsGroup().getWidestLabel();
            double d = this.getPixelLength() / (f + axisTypeProperties.getPaddingBetweenAxisLabels());
            this.xLabelFilter = (int)Math.ceil((double)super.getAxisLabelsGroup().size() / d);
        } else {
            this.xLabelFilter = 1;
        }
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        super.toHTML(hTMLGenerator);
        Field[] fieldArray = this.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                hTMLGenerator.addField(fieldArray[i].getName(), fieldArray[i].get(this));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        hTMLGenerator.propertiesTableEnd();
    }

    public float computeAxisCoordinate(float f, double d, double d2) {
        double d3 = (double)f + (d - d2) * this.getOneUnitPixelSize();
        return (float)d3;
    }
}

