/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.net.messaging.AbstractMessageHandler;
import com.icesoft.net.messaging.DefaultMessageService;
import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageHandler;
import com.icesoft.net.messaging.MessageSelector;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.net.messaging.MessageServiceException;
import com.icesoft.net.messaging.TextMessage;
import com.icesoft.net.messaging.expression.Equal;
import com.icesoft.net.messaging.expression.Expression;
import com.icesoft.net.messaging.expression.Identifier;
import com.icesoft.net.messaging.expression.Literal;
import com.icesoft.net.messaging.expression.Or;
import com.icesoft.net.messaging.expression.StringLiteral;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.push.server.BufferedContextEventsMessageHandler;
import org.icefaces.push.server.ContextEventMessageHandler;
import org.icefaces.push.server.ProductInfo;
import org.icefaces.push.server.UpdatedViewsMessageHandler;

public class PushServerMessageService
extends DefaultMessageService {
    private static final Log LOG = LogFactory.getLog((Class)PushServerMessageService.class);
    private final MessageHandler bufferedContextEventsMessageHandler = new BufferedContextEventsMessageHandler();
    private final MessageHandler contextEventMessageHandler = new ContextEventMessageHandler();
    private final MessageHandler helloMessageHandler = new AbstractMessageHandler(new MessageSelector((Expression)new Equal(new Identifier("message_type"), (Literal)new StringLiteral("Presence")))){

        public void handle(Message message) {
            if (message instanceof TextMessage && ((TextMessage)message).getText().equals("Hello")) {
                com.icesoft.util.Properties _messageProperties = new com.icesoft.util.Properties();
                _messageProperties.setStringProperty("destination_servletContextPath", message.getStringProperty("source_servletContextPath"));
                PushServerMessageService.this.getMessageServiceClient().publish("Acknowledge" + ";" + ProductInfo.PRODUCT + ";" + ProductInfo.PRIMARY + ";" + ProductInfo.SECONDARY + ";" + ProductInfo.TERTIARY + ";" + ProductInfo.RELEASE_TYPE + ";" + ProductInfo.BUILD_NO + ";" + ProductInfo.REVISION, (Properties)_messageProperties, "Presence", "icefacesPush");
            }
        }
    };
    private final MessageHandler updatedViewsMessageHandler = new UpdatedViewsMessageHandler();

    public PushServerMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) throws IllegalArgumentException {
        super(messageServiceClient, scheduledThreadPoolExecutor);
    }

    public PushServerMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, boolean retryOnFail) throws IllegalArgumentException {
        super(messageServiceClient, scheduledThreadPoolExecutor, retryOnFail);
    }

    public PushServerMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, Configuration configuration) throws IllegalArgumentException {
        super(messageServiceClient, scheduledThreadPoolExecutor, configuration);
    }

    public PushServerMessageService(MessageServiceClient messageServiceClient, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, Configuration configuration, boolean retryOnFail) throws IllegalArgumentException {
        super(messageServiceClient, scheduledThreadPoolExecutor, configuration, retryOnFail);
    }

    public MessageHandler getBufferedContextEventsMessageHandler() {
        return this.bufferedContextEventsMessageHandler;
    }

    public MessageHandler getContextEventMessageHandler() {
        return this.contextEventMessageHandler;
    }

    public MessageHandler getUpdatedViewsMessageHandler() {
        return this.updatedViewsMessageHandler;
    }

    protected void setUpMessageServiceClient() throws MessageServiceException {
        this.getMessageServiceClient().subscribe("icefacesPush", new MessageSelector((Expression)new Or(this.helloMessageHandler.getMessageSelector().getExpression(), (Expression)new Or(this.bufferedContextEventsMessageHandler.getMessageSelector().getExpression(), (Expression)new Or(this.contextEventMessageHandler.getMessageSelector().getExpression(), this.updatedViewsMessageHandler.getMessageSelector().getExpression())))));
        this.getMessageServiceClient().addMessageHandler(this.helloMessageHandler, "icefacesPush");
        this.getMessageServiceClient().addMessageHandler(this.bufferedContextEventsMessageHandler, "icefacesPush");
        this.getMessageServiceClient().addMessageHandler(this.contextEventMessageHandler, "icefacesPush");
        this.getMessageServiceClient().addMessageHandler(this.updatedViewsMessageHandler, "icefacesPush");
    }

    protected void tearDownMessageServiceClient() throws MessageServiceException {
        this.getMessageServiceClient().removeMessageHandler(this.updatedViewsMessageHandler, "icefacesPush");
        this.getMessageServiceClient().removeMessageHandler(this.contextEventMessageHandler, "icefacesPush");
        this.getMessageServiceClient().removeMessageHandler(this.bufferedContextEventsMessageHandler, "icefacesPush");
        this.getMessageServiceClient().removeMessageHandler(this.helloMessageHandler, "icefacesPush");
        this.getMessageServiceClient().unsubscribe("icefacesPush");
    }
}

