/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.ui.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;

public final class UrlUtils {
    private UrlUtils() {
    }

    private static String buildFullRequestUrl(String scheme, String serverName, int serverPort, String contextPath, String requestUrl, String servletPath, String requestURI, String pathInfo, String queryString) {
        boolean includePort = true;
        if ("http".equals(scheme.toLowerCase()) && serverPort == 80) {
            includePort = false;
        }
        if ("https".equals(scheme.toLowerCase()) && serverPort == 443) {
            includePort = false;
        }
        return scheme + "://" + serverName + (includePort ? ":" + serverPort : "") + contextPath + UrlUtils.buildRequestUrl(servletPath, requestURI, contextPath, pathInfo, queryString);
    }

    private static String buildRequestUrl(String servletPath, String requestURI, String contextPath, String pathInfo, String queryString) {
        String uri = servletPath;
        if (uri == null) {
            uri = requestURI;
            uri = uri.substring(contextPath.length());
        }
        return uri + (pathInfo == null ? "" : pathInfo) + (queryString == null ? "" : "?" + queryString);
    }

    public static String getFullRequestUrl(FilterInvocation fi) {
        HttpServletRequest r = fi.getHttpRequest();
        return UrlUtils.buildFullRequestUrl(r.getScheme(), r.getServerName(), r.getServerPort(), r.getContextPath(), r.getRequestURL().toString(), r.getServletPath(), r.getRequestURI(), r.getPathInfo(), r.getQueryString());
    }

    public static String getFullRequestUrl(SavedRequest sr) {
        return UrlUtils.buildFullRequestUrl(sr.getScheme(), sr.getServerName(), sr.getServerPort(), sr.getContextPath(), sr.getRequestURL(), sr.getServletPath(), sr.getRequestURI(), sr.getPathInfo(), sr.getQueryString());
    }

    public static String getRequestUrl(FilterInvocation fi) {
        HttpServletRequest r = fi.getHttpRequest();
        return UrlUtils.buildRequestUrl(r.getServletPath(), r.getRequestURI(), r.getContextPath(), r.getPathInfo(), r.getQueryString());
    }

    public static String getRequestUrl(SavedRequest sr) {
        return UrlUtils.buildRequestUrl(sr.getServletPath(), sr.getRequestURI(), sr.getContextPath(), sr.getPathInfo(), sr.getQueryString());
    }

    public static boolean isValidRedirectUrl(String url) {
        return !StringUtils.hasText((String)url) || url.startsWith("/") || url.toLowerCase().startsWith("http");
    }
}

