/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class JdbcDaoImpl
extends JdbcDaoSupport
implements UserDetailsService {
    public static final String DEF_USERS_BY_USERNAME_QUERY = "SELECT username,password,enabled FROM users WHERE username = ?";
    public static final String DEF_AUTHORITIES_BY_USERNAME_QUERY = "SELECT username,authority FROM authorities WHERE username = ?";
    public static final String DEF_GROUP_AUTHORITIES_BY_USERNAME_QUERY = "SELECT g.id, g.group_name, ga.authority FROM groups g, group_members gm, group_authorities ga WHERE gm.username = ? AND g.id = ga.group_id AND g.id = gm.group_id";
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private MappingSqlQuery authoritiesByUsernameMapping;
    private MappingSqlQuery groupAuthoritiesByUsernameMapping;
    private MappingSqlQuery usersByUsernameMapping;
    private String authoritiesByUsernameQuery = "SELECT username,authority FROM authorities WHERE username = ?";
    private String groupAuthoritiesByUsernameQuery = "SELECT g.id, g.group_name, ga.authority FROM groups g, group_members gm, group_authorities ga WHERE gm.username = ? AND g.id = ga.group_id AND g.id = gm.group_id";
    private String usersByUsernameQuery = "SELECT username,password,enabled FROM users WHERE username = ?";
    private String rolePrefix = "";
    private boolean usernameBasedPrimaryKey = true;
    private boolean enableAuthorities = true;
    private boolean enableGroups;

    protected void addCustomAuthorities(String username, List authorities) {
    }

    public String getUsersByUsernameQuery() {
        return this.usersByUsernameQuery;
    }

    protected void initDao() throws ApplicationContextException {
        Assert.isTrue((this.enableAuthorities || this.enableGroups ? 1 : 0) != 0, (String)"Use of either authorities or groups must be enabled");
        this.initMappingSqlQueries();
    }

    private void initMappingSqlQueries() {
        this.usersByUsernameMapping = new UsersByUsernameMapping(this.getDataSource());
        this.authoritiesByUsernameMapping = new AuthoritiesByUsernameMapping(this.getDataSource());
        this.groupAuthoritiesByUsernameMapping = new GroupAuthoritiesByUsernameMapping(this.getDataSource());
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        List users = this.loadUsersByUsername(username);
        if (users.size() == 0) {
            throw new UsernameNotFoundException(this.messages.getMessage("JdbcDaoImpl.notFound", new Object[]{username}, "Username {0} not found"), username);
        }
        UserDetails user = (UserDetails)users.get(0);
        HashSet dbAuthsSet = new HashSet();
        if (this.enableAuthorities) {
            dbAuthsSet.addAll(this.loadUserAuthorities(user.getUsername()));
        }
        if (this.enableGroups) {
            dbAuthsSet.addAll(this.loadGroupAuthorities(user.getUsername()));
        }
        ArrayList dbAuths = new ArrayList(dbAuthsSet);
        this.addCustomAuthorities(user.getUsername(), dbAuths);
        if (dbAuths.size() == 0) {
            throw new UsernameNotFoundException(this.messages.getMessage("JdbcDaoImpl.noAuthority", new Object[]{username}, "User {0} has no GrantedAuthority"), username);
        }
        GrantedAuthority[] arrayAuths = dbAuths.toArray(new GrantedAuthority[dbAuths.size()]);
        return this.createUserDetails(username, user, arrayAuths);
    }

    protected List loadUsersByUsername(String username) {
        return this.usersByUsernameMapping.execute(username);
    }

    protected List loadUserAuthorities(String username) {
        return this.authoritiesByUsernameMapping.execute(username);
    }

    protected List loadGroupAuthorities(String username) {
        return this.groupAuthoritiesByUsernameMapping.execute(username);
    }

    protected UserDetails createUserDetails(String username, UserDetails userFromUserQuery, GrantedAuthority[] combinedAuthorities) {
        String returnUsername = userFromUserQuery.getUsername();
        if (!this.usernameBasedPrimaryKey) {
            returnUsername = username;
        }
        return new User(returnUsername, userFromUserQuery.getPassword(), userFromUserQuery.isEnabled(), true, true, true, combinedAuthorities);
    }

    public void setAuthoritiesByUsernameQuery(String queryString) {
        this.authoritiesByUsernameQuery = queryString;
    }

    protected String getAuthoritiesByUsernameQuery() {
        return this.authoritiesByUsernameQuery;
    }

    public void setGroupAuthoritiesByUsernameQuery(String queryString) {
        this.groupAuthoritiesByUsernameQuery = queryString;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    protected String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setUsernameBasedPrimaryKey(boolean usernameBasedPrimaryKey) {
        this.usernameBasedPrimaryKey = usernameBasedPrimaryKey;
    }

    protected boolean isUsernameBasedPrimaryKey() {
        return this.usernameBasedPrimaryKey;
    }

    public void setUsersByUsernameQuery(String usersByUsernameQueryString) {
        this.usersByUsernameQuery = usersByUsernameQueryString;
    }

    protected boolean getEnableAuthorities() {
        return this.enableAuthorities;
    }

    public void setEnableAuthorities(boolean enableAuthorities) {
        this.enableAuthorities = enableAuthorities;
    }

    protected boolean getEnableGroups() {
        return this.enableGroups;
    }

    public void setEnableGroups(boolean enableGroups) {
        this.enableGroups = enableGroups;
    }

    private class UsersByUsernameMapping
    extends MappingSqlQuery {
        protected UsersByUsernameMapping(DataSource ds) {
            super(ds, JdbcDaoImpl.this.usersByUsernameQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String username = rs.getString(1);
            String password = rs.getString(2);
            boolean enabled = rs.getBoolean(3);
            User user = new User(username, password, enabled, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("HOLDER")});
            return user;
        }
    }

    private class GroupAuthoritiesByUsernameMapping
    extends MappingSqlQuery {
        protected GroupAuthoritiesByUsernameMapping(DataSource ds) {
            super(ds, JdbcDaoImpl.this.groupAuthoritiesByUsernameQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String roleName = JdbcDaoImpl.this.rolePrefix + rs.getString(3);
            GrantedAuthorityImpl authority = new GrantedAuthorityImpl(roleName);
            return authority;
        }
    }

    private class AuthoritiesByUsernameMapping
    extends MappingSqlQuery {
        protected AuthoritiesByUsernameMapping(DataSource ds) {
            super(ds, JdbcDaoImpl.this.authoritiesByUsernameQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String roleName = JdbcDaoImpl.this.rolePrefix + rs.getString(2);
            GrantedAuthorityImpl authority = new GrantedAuthorityImpl(roleName);
            return authority;
        }
    }
}

