/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.soap;

import java.net.URI;
import org.apache.woden.ErrorReporter;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.BindingOperation;
import org.apache.woden.wsdl20.NestedComponent;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.extensions.BaseComponentExtensionContext;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionProperty;
import org.apache.woden.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.extensions.http.HTTPHeader;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPConstants;
import org.apache.woden.wsdl20.extensions.soap.SOAPHeaderBlock;
import org.apache.woden.wsdl20.extensions.soap.SOAPModule;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.StringAttr;

public class SOAPBindingMessageReferenceExtensionsImpl
extends BaseComponentExtensionContext
implements SOAPBindingMessageReferenceExtensions {
    public SOAPBindingMessageReferenceExtensionsImpl(WSDLComponent parent, URI extNamespace, ErrorReporter errReporter) {
        super(parent, extNamespace, errReporter);
    }

    public ExtensionProperty[] getProperties() {
        return new ExtensionProperty[]{this.getProperty("soap modules"), this.getProperty("soap headers")};
    }

    public ExtensionProperty getProperty(String propertyName) {
        if ("soap modules".equals(propertyName)) {
            return this.newExtensionProperty("soap modules", this.getSoapModules());
        }
        if ("soap headers".equals(propertyName)) {
            return this.newExtensionProperty("soap headers", this.getSoapHeaders());
        }
        return null;
    }

    public SOAPModule[] getSoapModules() {
        ExtensionElement[] extEls = ((WSDLElement)this.getParent()).getExtensionElementsOfType(SOAPConstants.Q_ELEM_SOAP_MODULE);
        int len = extEls.length;
        SOAPModule[] soapMods = new SOAPModule[len];
        System.arraycopy(extEls, 0, soapMods, 0, len);
        return soapMods;
    }

    public SOAPHeaderBlock[] getSoapHeaders() {
        ExtensionElement[] extEls = ((WSDLElement)this.getParent()).getExtensionElementsOfType(SOAPConstants.Q_ELEM_SOAP_HEADER);
        int len = extEls.length;
        SOAPHeaderBlock[] soapHeaders = new SOAPHeaderBlock[len];
        System.arraycopy(extEls, 0, soapHeaders, 0, len);
        return soapHeaders;
    }

    public String getHttpContentEncoding() {
        BindingOperation bindingOp = (BindingOperation)((NestedComponent)this.getParent()).getParent();
        Binding binding = (Binding)bindingOp.getParent();
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(version) && protocol.equals(SOAPConstants.PROTOCOL_URI_SOAP12_HTTP) || "1.1".equals(version) && protocol.equals(SOAPConstants.PROTOCOL_URI_SOAP11_HTTP)) {
            StringAttr contEncoding = (StringAttr)((WSDLElement)this.getParent()).getExtensionAttribute(HTTPConstants.Q_ATTR_CONTENT_ENCODING);
            return contEncoding != null ? contEncoding.getString() : null;
        }
        return null;
    }

    public HTTPHeader[] getHttpHeaders() {
        BindingOperation bindingOp = (BindingOperation)((NestedComponent)this.getParent()).getParent();
        Binding binding = (Binding)bindingOp.getParent();
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return new HTTPHeader[0];
        }
        if ("1.2".equals(version) && protocol.equals(SOAPConstants.PROTOCOL_URI_SOAP12_HTTP) || "1.1".equals(version) && protocol.equals(SOAPConstants.PROTOCOL_URI_SOAP11_HTTP)) {
            ExtensionElement[] extEls = ((WSDLElement)this.getParent()).getExtensionElementsOfType(HTTPConstants.Q_ELEM_HTTP_HEADER);
            int len = extEls.length;
            HTTPHeader[] httpHeaders = new HTTPHeader[len];
            System.arraycopy(extEls, 0, httpHeaders, 0, len);
            return httpHeaders;
        }
        return new HTTPHeader[0];
    }
}

