/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description.java2wsdl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;

public class TypeTable {
    private static HashMap simpleTypetoxsd;
    public static final QName ANY_TYPE;
    private HashMap complexTypeMap = new HashMap();

    private static void populateSimpleTypes() {
        simpleTypetoxsd = new HashMap();
        simpleTypetoxsd.put("int", new QName("http://www.w3.org/2001/XMLSchema", "int", "xs"));
        simpleTypetoxsd.put("java.lang.String", new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"));
        simpleTypetoxsd.put("boolean", new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xs"));
        simpleTypetoxsd.put("float", new QName("http://www.w3.org/2001/XMLSchema", "float", "xs"));
        simpleTypetoxsd.put("double", new QName("http://www.w3.org/2001/XMLSchema", "double", "xs"));
        simpleTypetoxsd.put("short", new QName("http://www.w3.org/2001/XMLSchema", "short", "xs"));
        simpleTypetoxsd.put("long", new QName("http://www.w3.org/2001/XMLSchema", "long", "xs"));
        simpleTypetoxsd.put("byte", new QName("http://www.w3.org/2001/XMLSchema", "byte", "xs"));
        simpleTypetoxsd.put("char", new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"));
        simpleTypetoxsd.put("java.lang.Integer", new QName("http://www.w3.org/2001/XMLSchema", "int", "xs"));
        simpleTypetoxsd.put("java.lang.Double", new QName("http://www.w3.org/2001/XMLSchema", "double", "xs"));
        simpleTypetoxsd.put("java.lang.Float", new QName("http://www.w3.org/2001/XMLSchema", "float", "xs"));
        simpleTypetoxsd.put("java.lang.Long", new QName("http://www.w3.org/2001/XMLSchema", "long", "xs"));
        simpleTypetoxsd.put("java.lang.Character", ANY_TYPE);
        simpleTypetoxsd.put("java.lang.Boolean", new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xs"));
        simpleTypetoxsd.put("java.lang.Byte", new QName("http://www.w3.org/2001/XMLSchema", "byte", "xs"));
        simpleTypetoxsd.put("java.lang.Short", new QName("http://www.w3.org/2001/XMLSchema", "short", "xs"));
        simpleTypetoxsd.put("java.util.Date", new QName("http://www.w3.org/2001/XMLSchema", "date", "xs"));
        simpleTypetoxsd.put("java.util.Calendar", new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xs"));
        simpleTypetoxsd.put("java.sql.Date", new QName("http://www.w3.org/2001/XMLSchema", "date", "xs"));
        simpleTypetoxsd.put("java.sql.Time", new QName("http://www.w3.org/2001/XMLSchema", "time", "xs"));
        simpleTypetoxsd.put("java.sql.Timestamp", new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xs"));
        simpleTypetoxsd.put("java.math.BigDecimal", new QName("http://www.w3.org/2001/XMLSchema", "decimal", "xs"));
        simpleTypetoxsd.put("java.math.BigInteger", new QName("http://www.w3.org/2001/XMLSchema", "integer", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.Day", new QName("http://www.w3.org/2001/XMLSchema", "gDay", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.Duration", new QName("http://www.w3.org/2001/XMLSchema", "duration", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.Month", new QName("http://www.w3.org/2001/XMLSchema", "gMonth", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.MonthDay", new QName("http://www.w3.org/2001/XMLSchema", "gMonthDay", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.Time", new QName("http://www.w3.org/2001/XMLSchema", "time", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.Year", new QName("http://www.w3.org/2001/XMLSchema", "gYear", "xs"));
        simpleTypetoxsd.put("org.apache.axis2.databinding.types.YearMonth", new QName("http://www.w3.org/2001/XMLSchema", "gYearMonth", "xs"));
        simpleTypetoxsd.put("java.lang.Object", ANY_TYPE);
        simpleTypetoxsd.put(OMElement.class.getName(), ANY_TYPE);
        simpleTypetoxsd.put(ArrayList.class.getName(), ANY_TYPE);
        simpleTypetoxsd.put(Vector.class.getName(), ANY_TYPE);
        simpleTypetoxsd.put(List.class.getName(), ANY_TYPE);
        simpleTypetoxsd.put(HashMap.class.getName(), ANY_TYPE);
        simpleTypetoxsd.put(Hashtable.class.getName(), ANY_TYPE);
        simpleTypetoxsd.put("base64Binary", new QName("http://www.w3.org/2001/XMLSchema", "base64Binary", "xs"));
    }

    public QName getSimpleSchemaTypeName(String typeName) {
        QName qName = (QName)simpleTypetoxsd.get(typeName);
        if (qName == null && (typeName.startsWith("java.lang") || typeName.startsWith("javax.")) && !Exception.class.getName().equals(typeName)) {
            return ANY_TYPE;
        }
        return qName;
    }

    public boolean isSimpleType(String typeName) {
        if (simpleTypetoxsd.keySet().contains(typeName)) {
            return true;
        }
        return typeName.startsWith("java.lang") || typeName.startsWith("javax.");
    }

    public Map getComplexSchemaMap() {
        return this.complexTypeMap;
    }

    public void addComplexSchema(String name, QName schemaType) {
        this.complexTypeMap.put(name, schemaType);
    }

    public QName getComplexSchemaType(String name) {
        return (QName)this.complexTypeMap.get(name);
    }

    public QName getQNamefortheType(String typeName) {
        QName type = this.getSimpleSchemaTypeName(typeName);
        if (type == null) {
            type = this.getComplexSchemaType(typeName);
        }
        return type;
    }

    static {
        ANY_TYPE = new QName("http://www.w3.org/2001/XMLSchema", "anyType", "xs");
        TypeTable.populateSimpleTypes();
    }
}

