/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart.axis;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.lang.reflect.Field;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.axisChart.axis.Axis;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.AxisTypeProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.util.ChartFont;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.test.HTMLTestable;

public class YAxis
extends Axis
implements HTMLTestable {
    private float lastTickY;

    public YAxis(AxisChart axisChart, int n) {
        super(axisChart, n);
    }

    public float getLastTickY() {
        return this.lastTickY;
    }

    public void computeMinimumWidthNeeded(String string) {
        AxisTypeProperties axisTypeProperties = super.getAxisChart().getAxisProperties().getYAxisProperties();
        float f = 0.0f;
        if (axisTypeProperties.showAxisLabels()) {
            f = axisTypeProperties.getShowRightAxis() ? (super.getAxisLabelsGroupRight().getWidestLabel() > super.getAxisLabelsGroup().getWidestLabel() ? (f += super.getAxisLabelsGroupRight().getWidestLabel()) : (f += super.getAxisLabelsGroup().getWidestLabel())) : (f += super.getAxisLabelsGroup().getWidestLabel());
        }
        if (axisTypeProperties.getShowTicks() != 0) {
            f += axisTypeProperties.getPaddingBetweenLabelsAndTicks();
            f += axisTypeProperties.getAxisTickMarkPixelLength();
        } else if (axisTypeProperties.showAxisLabels()) {
            f += axisTypeProperties.getPaddingBetweenAxisAndLabels();
        }
        if (string != null) {
            super.computeAxisTitleDimensions(string, axisTypeProperties.getTitleChartFont());
            f += super.getTitleHeight();
            f += axisTypeProperties.getPaddingBetweenAxisTitleAndLabels();
        }
        super.setMinimumWidthNeeded(f);
    }

    private void renderAxisTitle(String string, Graphics2D graphics2D, AxisTypeProperties axisTypeProperties) {
        if (string != null) {
            float f = super.getAxisChart().getXAxis().getOrigin() - super.getMinimumWidthNeeded() + super.getTitleHeight();
            float f2 = super.getTitleWidth() > super.getPixelLength() ? (float)super.getAxisChart().getImageHeight() - ((float)super.getAxisChart().getImageHeight() - super.getTitleWidth()) / 2.0f : this.getOrigin() - (super.getPixelLength() - super.getTitleWidth()) / 2.0f;
            graphics2D.setFont(axisTypeProperties.getAxisTitleChartFont().getFont().deriveFont(ChartFont.VERTICAL_ROTATION));
            graphics2D.setPaint(axisTypeProperties.getAxisTitleChartFont().getPaint());
            graphics2D.drawString(string, f, f2);
        }
    }

    public void render(Graphics2D graphics2D, AxisProperties axisProperties, String string) {
        DataAxisProperties dataAxisProperties;
        float f;
        Line2D.Float float_;
        AxisTypeProperties axisTypeProperties = axisProperties.getYAxisProperties();
        this.renderAxisTitle(string, graphics2D, axisProperties.getYAxisProperties());
        float f2 = 0.0f;
        if (axisTypeProperties instanceof DataAxisProperties) {
            float_ = new Line2D.Float(0.0f, super.getOrigin(), 0.0f, super.getOrigin());
            if (axisTypeProperties.showAxisLabels()) {
                f2 = super.getOrigin() + super.getAxisLabelsGroup().getTallestLabel() / 4.0f;
            }
        } else {
            f = super.getOrigin() - super.getScalePixelWidth() / 2.0f;
            float_ = new Line2D.Float(0.0f, f, 0.0f, f);
            if (axisTypeProperties.showAxisLabels()) {
                f2 = f + super.getAxisLabelsGroup().getTallestLabel() / 4.0f;
                super.getAxisLabelsGroup().reverse();
            }
        }
        f = super.getAxisChart().getXAxis().getOrigin() - axisTypeProperties.getAxisTickMarkPixelLength();
        float f3 = super.getAxisChart().getXAxis().getOrigin();
        float f4 = super.getAxisChart().getXAxis().getOrigin() + 1.0f;
        float f5 = super.getAxisChart().getXAxis().getOrigin() + super.getAxisChart().getXAxis().getPixelLength();
        float f6 = super.getAxisChart().getXAxis().getOrigin() - axisTypeProperties.getAxisTickMarkPixelLength();
        if (axisTypeProperties.showAxisLabels()) {
            f6 -= axisTypeProperties.getPaddingBetweenLabelsAndTicks();
        }
        for (int i = 0; i < super.getNumberOfScaleItems(); ++i) {
            if (axisTypeProperties.getShowGridLines() != 0 && (i > 0 || i == 0 && !(axisTypeProperties instanceof DataAxisProperties))) {
                float_.x1 = f4;
                float_.x2 = f5;
                if (i < super.getAxisLabelsGroup().size() || i == super.getAxisLabelsGroup().size() && !axisTypeProperties.getShowEndBorder()) {
                    axisTypeProperties.getGridLineChartStroke().draw(graphics2D, float_);
                } else {
                    axisProperties.getXAxisProperties().getAxisStroke().draw(graphics2D, float_);
                }
            }
            if (axisTypeProperties.getShowTicks() != 0) {
                float_.x1 = f;
                float_.x2 = f3;
                axisTypeProperties.getTickChartStroke().draw(graphics2D, float_);
            }
            this.lastTickY = float_.y1;
            float_.y1 -= super.getScalePixelWidth();
            float_.y2 = float_.y1;
            if (axisTypeProperties.showAxisLabels()) {
                super.getAxisLabelsGroup().render(i, graphics2D, f6 - super.getAxisLabelsGroup().getTextTag(i).getWidth(), f2);
            }
            f2 -= super.getScalePixelWidth();
        }
        float_.x2 = float_.x1 = super.getAxisChart().getXAxis().getOrigin();
        float_.y1 = super.getOrigin() - super.getPixelLength();
        float_.y2 = super.getOrigin();
        axisTypeProperties.getAxisStroke().draw(graphics2D, float_);
        if (axisTypeProperties.getShowEndBorder()) {
            float_.x1 = super.getAxisChart().getXAxis().getOrigin();
            float_.x2 = super.getAxisChart().getXAxis().getOrigin() + super.getAxisChart().getXAxis().getPixelLength();
            float_.y2 = float_.y1 = super.getOrigin() - super.getPixelLength();
            axisProperties.getXAxisProperties().getAxisStroke().draw(graphics2D, float_);
        }
        if (axisTypeProperties instanceof DataAxisProperties && (dataAxisProperties = (DataAxisProperties)axisTypeProperties).showZeroLine() && super.getScaleCalculator().getMinValue() < 0.0 && super.getScaleCalculator().getMaxValue() > 0.0) {
            float_.y2 = float_.y1 = super.getZeroLineCoordinate();
            float_.x1 = super.getAxisChart().getXAxis().getOrigin();
            float_.x2 = super.getAxisChart().getXAxis().getOrigin() + super.getAxisChart().getXAxis().getPixelLength();
            dataAxisProperties.getZeroLineChartStroke().draw(graphics2D, float_);
        }
        if (axisTypeProperties.getShowRightAxis()) {
            float_.x2 = float_.x1 = super.getAxisChart().getXAxis().getOrigin() + super.getAxisChart().getXAxis().getPixelLength();
            float_.y1 = super.getOrigin() - super.getPixelLength() - 10.0f;
            float_.y2 = super.getOrigin();
            axisTypeProperties.getAxisStroke().draw(graphics2D, float_);
            float f7 = super.getAxisChart().getXAxis().getOrigin() + super.getAxisChart().getXAxis().getPixelLength();
            float f8 = f7 + axisTypeProperties.getAxisTickMarkPixelLength();
            float_.y2 = float_.y1 = super.getOrigin();
            f2 = super.getOrigin() + super.getAxisLabelsGroupRight().getTallestLabel() / 4.0f;
            f6 = super.getAxisChart().getXAxis().getOrigin() + axisTypeProperties.getAxisTickMarkPixelLength() + super.getAxisChart().getXAxis().getPixelLength();
            f6 += axisTypeProperties.getPaddingBetweenLabelsAndTicks();
            for (int i = 0; i < super.getNumberOfScaleItems(); ++i) {
                if (axisTypeProperties.getShowTicks() != 0) {
                    float_.x1 = f7;
                    float_.x2 = f8;
                    axisTypeProperties.getTickChartStroke().draw(graphics2D, float_);
                }
                float_.y1 -= super.getScalePixelWidth();
                float_.y2 = float_.y1;
                if (axisTypeProperties.showAxisLabels()) {
                    super.getAxisLabelsGroupRight().render(i, graphics2D, f6, f2);
                }
                f2 -= super.getScalePixelWidth();
            }
        }
    }

    public float computeAxisCoordinate(float f, double d, double d2) {
        double d3 = (double)f - (d - d2) * this.getOneUnitPixelSize();
        return (float)d3;
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        super.toHTML(hTMLGenerator);
        Field[] fieldArray = this.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                hTMLGenerator.addField(fieldArray[i].getName(), fieldArray[i].get(this));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        hTMLGenerator.propertiesTableEnd();
    }
}

