/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;

public class OutgoingFileTransfer
extends FileTransfer {
    private static int RESPONSE_TIMEOUT = 60000;
    private NegotiationProgress callback;
    private OutputStream outputStream;
    private String initiator;
    private Thread transferThread;

    public static int getResponseTimeout() {
        return RESPONSE_TIMEOUT;
    }

    public static void setResponseTimeout(int responseTimeout) {
        RESPONSE_TIMEOUT = responseTimeout;
    }

    protected OutgoingFileTransfer(String initiator, String target, String streamID, FileTransferNegotiator transferNegotiator) {
        super(target, streamID, transferNegotiator);
        this.initiator = initiator;
    }

    protected void setOutputStream(OutputStream stream) {
        if (this.outputStream == null) {
            this.outputStream = stream;
        }
    }

    protected OutputStream getOutputStream() {
        if (this.getStatus().equals((Object)FileTransfer.Status.negotiated)) {
            return this.outputStream;
        }
        return null;
    }

    public synchronized OutputStream sendFile(String fileName, long fileSize, String description) throws XMPPException {
        if (this.isDone() || this.outputStream != null) {
            throw new IllegalStateException("The negotation process has already been attempted on this file transfer");
        }
        try {
            this.outputStream = this.negotiateStream(fileName, fileSize, description);
        }
        catch (XMPPException e) {
            this.handleXMPPException(e);
            throw e;
        }
        return this.outputStream;
    }

    public synchronized void sendFile(final String fileName, final long fileSize, final String description, final NegotiationProgress progress) {
        if (progress == null) {
            throw new IllegalArgumentException("Callback progress cannot be null.");
        }
        this.checkTransferThread();
        if (this.isDone() || this.outputStream != null) {
            throw new IllegalStateException("The negotation process has already been attempted for this file transfer");
        }
        this.callback = progress;
        this.transferThread = new Thread(new Runnable(){

            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(fileName, fileSize, description);
                    progress.outputStreamEstablished(OutgoingFileTransfer.this.outputStream);
                }
                catch (XMPPException e) {
                    OutgoingFileTransfer.this.handleXMPPException(e);
                }
            }
        }, "File Transfer Negotiation " + this.streamID);
        this.transferThread.start();
    }

    private void checkTransferThread() {
        if (this.transferThread != null && this.transferThread.isAlive() || this.isDone()) {
            throw new IllegalStateException("File transfer in progress or has already completed.");
        }
    }

    public synchronized void sendFile(final File file, final String description) throws XMPPException {
        this.checkTransferThread();
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Could not read file");
        }
        this.setFileInfo(file.getAbsolutePath(), file.getName(), file.length());
        this.transferThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    OutgoingFileTransfer.this.outputStream = OutgoingFileTransfer.this.negotiateStream(file.getName(), file.length(), description);
                }
                catch (XMPPException e) {
                    OutgoingFileTransfer.this.handleXMPPException(e);
                    return;
                }
                if (OutgoingFileTransfer.this.outputStream == null) {
                    return;
                }
                if (!OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.negotiated, FileTransfer.Status.in_progress)) {
                    return;
                }
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(file);
                    OutgoingFileTransfer.this.writeToStream(inputStream, OutgoingFileTransfer.this.outputStream);
                }
                catch (FileNotFoundException e) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setError(FileTransfer.Error.bad_file);
                    OutgoingFileTransfer.this.setException(e);
                }
                catch (XMPPException e) {
                    OutgoingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    OutgoingFileTransfer.this.setException((Exception)((Object)e));
                }
                finally {
                    try {
                        if (inputStream != null) {
                            ((InputStream)inputStream).close();
                        }
                        OutgoingFileTransfer.this.outputStream.flush();
                        OutgoingFileTransfer.this.outputStream.close();
                    }
                    catch (IOException e) {}
                }
                OutgoingFileTransfer.this.updateStatus(FileTransfer.Status.in_progress, FileTransfer.Status.complete);
            }
        }, "File Transfer " + this.streamID);
        this.transferThread.start();
    }

    private void handleXMPPException(XMPPException e) {
        XMPPError error = e.getXMPPError();
        if (error != null) {
            int code = error.getCode();
            if (code == 403) {
                this.setStatus(FileTransfer.Status.refused);
                return;
            }
            if (code == 400) {
                this.setStatus(FileTransfer.Status.error);
                this.setError(FileTransfer.Error.not_acceptable);
            } else {
                this.setStatus(FileTransfer.Status.error);
            }
        }
        this.setException((Exception)((Object)e));
    }

    public long getBytesSent() {
        return this.amountWritten;
    }

    private OutputStream negotiateStream(String fileName, long fileSize, String description) throws XMPPException {
        if (!this.updateStatus(FileTransfer.Status.initial, FileTransfer.Status.negotiating_transfer)) {
            throw new XMPPException("Illegal state change");
        }
        StreamNegotiator streamNegotiator = this.negotiator.negotiateOutgoingTransfer(this.getPeer(), this.streamID, fileName, fileSize, description, RESPONSE_TIMEOUT);
        if (streamNegotiator == null) {
            this.setStatus(FileTransfer.Status.error);
            this.setError(FileTransfer.Error.no_response);
            return null;
        }
        if (!this.updateStatus(FileTransfer.Status.negotiating_transfer, FileTransfer.Status.negotiating_stream)) {
            throw new XMPPException("Illegal state change");
        }
        this.outputStream = streamNegotiator.createOutgoingStream(this.streamID, this.initiator, this.getPeer());
        if (!this.updateStatus(FileTransfer.Status.negotiating_stream, FileTransfer.Status.negotiated)) {
            throw new XMPPException("Illegal state change");
        }
        return this.outputStream;
    }

    public void cancel() {
        this.setStatus(FileTransfer.Status.cancelled);
    }

    protected boolean updateStatus(FileTransfer.Status oldStatus, FileTransfer.Status newStatus) {
        boolean isUpdated = super.updateStatus(oldStatus, newStatus);
        if (this.callback != null && isUpdated) {
            this.callback.statusUpdated(oldStatus, newStatus);
        }
        return isUpdated;
    }

    protected void setStatus(FileTransfer.Status status) {
        FileTransfer.Status oldStatus = this.getStatus();
        super.setStatus(status);
        if (this.callback != null) {
            this.callback.statusUpdated(oldStatus, status);
        }
    }

    protected void setException(Exception exception) {
        super.setException(exception);
        if (this.callback != null) {
            this.callback.errorEstablishingStream(exception);
        }
    }

    public static interface NegotiationProgress {
        public void statusUpdated(FileTransfer.Status var1, FileTransfer.Status var2);

        public void outputStreamEstablished(OutputStream var1);

        public void errorEstablishingStream(Exception var1);
    }
}

