/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.context.View;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.OKResponse;
import com.icesoft.faces.webapp.http.portlet.page.AssociatedPageViews;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DisposeViews
implements Server {
    private static final Log Log = LogFactory.getLog((Class)DisposeViews.class);
    private String sessionID;
    private Map views;
    private AssociatedPageViews associatedPageViews;

    public DisposeViews(String sessionID, Map views, AssociatedPageViews associatedPageViews) {
        this.sessionID = sessionID;
        this.views = views;
        this.associatedPageViews = associatedPageViews;
    }

    public void service(Request request) throws Exception {
        if (request.containsParameter(this.sessionID)) {
            String[] viewIdentifiers = request.getParameterAsStrings(this.sessionID);
            for (int i = 0; i < viewIdentifiers.length; ++i) {
                View view = (View)this.views.remove(viewIdentifiers[i]);
                if (view == null) continue;
                this.associatedPageViews.disposeAssociatedViews(view);
                view.dispose();
            }
            if (Log.isDebugEnabled()) {
                Log.debug((Object)("Views disposed for " + this.sessionID + ". Remaining views: " + this.views));
            }
        } else {
            Log.warn((Object)"Request belonging to a different session. Most probably servlet filters mangled the request.");
        }
        request.respondWith(OKResponse.Handler);
    }

    public void shutdown() {
    }
}

