/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;

public class FlowExecutorUtil {
    private FlowExecutor flowExecutor;
    private ExternalContext externalContext;

    public FlowExecutorUtil(FlowExecutor flowExecutor, ExternalContext externalContext) {
        this.flowExecutor = flowExecutor;
        this.externalContext = externalContext;
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    protected MutableAttributeMap defaultFlowExecutionInputMap(HttpServletRequest request) {
        LocalAttributeMap inputMap = new LocalAttributeMap();
        Map parameterMap = request.getParameterMap();
        Iterator it = parameterMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values.length == 1) {
                inputMap.put(name, (Object)values[0]);
                continue;
            }
            inputMap.put(name, (Object)values);
        }
        return inputMap;
    }

    protected MutableAttributeMap defaultFlowExecutionInputMapPortlet(PortletRequest request) {
        LocalAttributeMap inputMap = new LocalAttributeMap();
        Map parameterMap = request.getParameterMap();
        Iterator it = parameterMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values.length == 1) {
                inputMap.put(name, (Object)values[0]);
                continue;
            }
            inputMap.put(name, (Object)values);
        }
        return inputMap;
    }

    protected FlowExecutionResult resumeExecution(String flowExecutionKey) {
        return this.flowExecutor.resumeExecution(flowExecutionKey, this.externalContext);
    }

    protected FlowExecutionResult launchExecution(MutableAttributeMap input, String flowId) {
        return this.flowExecutor.launchExecution(flowId, input, this.externalContext);
    }
}

