/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util;

import com.icesoft.util.PropertyException;
import com.icesoft.util.Validator;
import java.io.Serializable;
import java.util.Map;

public class Properties
extends java.util.Properties
implements Cloneable,
Map,
Serializable {
    private Validator keyValidator;
    private Validator valueValidator;

    public Properties() {
        this(null, new PropertyKeyValidator(), new PropertyValueValidator());
    }

    public Properties(Properties defaults) {
        this(defaults, new PropertyKeyValidator(), new PropertyValueValidator());
    }

    public Properties(Properties defaults, Validator keyValidator, Validator valueValidator) {
        super(defaults);
        this.setKeyValidator(keyValidator);
        this.setValueValidator(valueValidator);
    }

    public Properties(Validator keyValidator, Validator valueValidator) {
        this(null, keyValidator, valueValidator);
    }

    public static boolean getBooleanProperty(java.util.Properties properties, String name) throws IllegalArgumentException, PropertyException {
        if (properties != null) {
            if (properties.containsKey(name)) {
                return Properties.asBoolean(properties.get(name));
            }
            throw new PropertyException("property not found for name: " + name);
        }
        throw new IllegalArgumentException("properties is null");
    }

    public static boolean getBooleanProperty(java.util.Properties properties, String name, boolean defaultValue) throws PropertyException {
        if (properties != null && properties.containsKey(name)) {
            return Properties.asBoolean(properties.get(name));
        }
        return defaultValue;
    }

    public boolean getBooleanProperty(String key) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getBooleanProperty(this, key);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getBooleanProperty(this.defaults, key);
        }
        throw new PropertyException("property not found for key: " + key);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getBooleanProperty(this, key, defaultValue);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getBooleanProperty(this.defaults, key, defaultValue);
        }
        return defaultValue;
    }

    public static byte getByteProperty(java.util.Properties properties, String name) throws IllegalArgumentException, PropertyException {
        if (properties != null) {
            if (properties.containsKey(name)) {
                return Properties.asByte(properties.get(name));
            }
            throw new PropertyException("property not found for name: " + name);
        }
        throw new IllegalArgumentException("properties is null");
    }

    public static byte getByteProperty(java.util.Properties properties, String name, byte defaultValue) throws PropertyException {
        if (properties != null && properties.containsKey(name)) {
            return Properties.asByte(properties.get(name));
        }
        return defaultValue;
    }

    public byte getByteProperty(String key) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getByteProperty(this, key);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getByteProperty(this.defaults, key);
        }
        throw new PropertyException("value is not a byte: null");
    }

    public byte getByteProperty(String key, byte defaultValue) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getByteProperty(this, key, defaultValue);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getByteProperty(this.defaults, key, defaultValue);
        }
        return defaultValue;
    }

    public static double getDoubleProperty(java.util.Properties properties, String key) throws IllegalArgumentException, PropertyException {
        if (properties != null) {
            if (properties.containsKey(key)) {
                return Properties.asDouble(properties.get(key));
            }
            throw new PropertyException("property not found for key: " + key);
        }
        throw new IllegalArgumentException("properties is null");
    }

    public static double getDoubleProperty(java.util.Properties properties, String key, double defaultValue) throws PropertyException {
        if (properties != null && properties.containsKey(key)) {
            return Properties.asDouble(properties.get(key));
        }
        return defaultValue;
    }

    public double getDoubleProperty(String key) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getDoubleProperty(this, key);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getDoubleProperty(this.defaults, key);
        }
        throw new PropertyException("value is not a double: null");
    }

    public double getDoubleProperty(String key, double defaultValue) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getDoubleProperty(this, key, defaultValue);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getDoubleProperty(this.defaults, key, defaultValue);
        }
        return defaultValue;
    }

    public static float getFloatProperty(java.util.Properties properties, String key) throws IllegalArgumentException, PropertyException {
        if (properties != null) {
            if (properties.containsKey(key)) {
                return Properties.asFloat(properties.get(key));
            }
            throw new PropertyException("property not found for key: " + key);
        }
        throw new IllegalArgumentException("properties is null");
    }

    public static float getFloatProperty(java.util.Properties properties, String key, float defaultValue) throws PropertyException {
        if (properties != null && properties.containsKey(key)) {
            return Properties.asFloat(properties.get(key));
        }
        return defaultValue;
    }

    public float getFloatProperty(String key) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getFloatProperty(this, key);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getFloatProperty(this.defaults, key);
        }
        throw new PropertyException("value is not a float: null");
    }

    public float getFloatProperty(String key, float defaultValue) {
        if (this.containsKey(key)) {
            return Properties.getFloatProperty(this, key, defaultValue);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getFloatProperty(this.defaults, key, defaultValue);
        }
        return defaultValue;
    }

    public static int getIntProperty(java.util.Properties properties, String key) throws IllegalArgumentException, PropertyException {
        if (properties != null) {
            if (properties.containsKey(key)) {
                return Properties.asInt(properties.get(key));
            }
            throw new PropertyException("property not found for key: " + key);
        }
        throw new IllegalArgumentException("properties is null");
    }

    public static int getIntProperty(java.util.Properties properties, String key, int defaultValue) throws PropertyException {
        if (properties != null && properties.containsKey(key)) {
            return Properties.asInt(properties.get(key));
        }
        return defaultValue;
    }

    public int getIntProperty(String key) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getIntProperty(this, key);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getIntProperty(this.defaults, key);
        }
        throw new PropertyException("value is not an int: null");
    }

    public int getIntProperty(String key, int defaultValue) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getIntProperty(this, key, defaultValue);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getIntProperty(this.defaults, key, defaultValue);
        }
        return defaultValue;
    }

    public Validator getKeyValidator() {
        return this.keyValidator;
    }

    public static long getLongProperty(java.util.Properties properties, String key) throws IllegalArgumentException, PropertyException {
        if (properties != null) {
            if (properties.containsKey(key)) {
                return Properties.asLong(properties.get(key));
            }
            throw new PropertyException("property not found for key: " + key);
        }
        throw new IllegalArgumentException("properties is null");
    }

    public static long getLongProperty(java.util.Properties properties, String key, long defaultValue) throws PropertyException {
        if (properties != null && properties.containsKey(key)) {
            return Properties.asLong(properties.get(key));
        }
        return defaultValue;
    }

    public long getLongProperty(String key) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getLongProperty(this, key);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getLongProperty(this.defaults, key);
        }
        throw new PropertyException("value is not a long: null");
    }

    public long getLongProperty(String key, long defaultValue) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getLongProperty(this, key, defaultValue);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getLongProperty(this.defaults, key, defaultValue);
        }
        return defaultValue;
    }

    public static Object getObjectProperty(java.util.Properties properties, String key) {
        return Properties.getObjectProperty(properties, key, null);
    }

    public static Object getObjectProperty(java.util.Properties properties, String key, Object defaultValue) {
        if (properties == null || !properties.containsKey(key)) {
            return defaultValue;
        }
        return properties.get(key);
    }

    public Object getObjectProperty(String key) {
        return this.getObjectProperty(key, null);
    }

    public Object getObjectProperty(String key, Object defaultValue) {
        if (this.containsKey(key)) {
            return Properties.getObjectProperty(this, key);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getObjectProperty(this.defaults, key);
        }
        return defaultValue;
    }

    public String getProperty(String key) {
        return this.getStringProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getStringProperty(key, defaultValue);
    }

    public static short getShortProperty(java.util.Properties properties, String key) throws IllegalArgumentException, PropertyException {
        if (properties != null) {
            if (properties.containsKey(key)) {
                return Properties.asShort(properties.get(key));
            }
            throw new PropertyException("property not found for key: " + key);
        }
        throw new IllegalArgumentException("properties is null");
    }

    public static short getShortProperty(java.util.Properties properties, String key, short defaultValue) throws PropertyException {
        if (properties != null && properties.containsKey(key)) {
            return Properties.asShort(properties.get(key));
        }
        return defaultValue;
    }

    public short getShortProperty(String key) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getShortProperty(this, key);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getShortProperty(this.defaults, key);
        }
        throw new PropertyException("value is not a short: null");
    }

    public short getShortProperty(String key, short defaultValue) throws PropertyException {
        if (this.containsKey(key)) {
            return Properties.getShortProperty(this, key, defaultValue);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getShortProperty(this.defaults, key, defaultValue);
        }
        return defaultValue;
    }

    public static String getStringProperty(java.util.Properties properties, String key) {
        return Properties.getStringProperty(properties, key, null);
    }

    public static String getStringProperty(java.util.Properties properties, String key, String defaultValue) {
        if (properties == null || !properties.containsKey(key)) {
            return defaultValue;
        }
        return String.valueOf(properties.get(key));
    }

    public String getStringProperty(String key) {
        return this.getStringProperty(key, null);
    }

    public String getStringProperty(String key, String defaultValue) {
        if (this.containsKey(key)) {
            return Properties.getStringProperty(this, key);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return Properties.getStringProperty(this.defaults, key);
        }
        return defaultValue;
    }

    public Validator getValueValidator() {
        return this.valueValidator;
    }

    public synchronized Object put(Object key, Object value) throws PropertyException {
        this.validateKey(key);
        this.validateValue(value);
        return super.put(key, value);
    }

    public static Object setBooleanProperty(java.util.Properties properties, String key, boolean value) throws PropertyException {
        if (properties != null) {
            return properties.put(key, new Boolean(value));
        }
        return null;
    }

    public synchronized Object setBooleanProperty(String key, boolean value) throws PropertyException {
        return Properties.setBooleanProperty(this, key, value);
    }

    public static Object setByteProperty(java.util.Properties properties, String key, byte value) throws PropertyException {
        if (properties != null) {
            return properties.put(key, new Byte(value));
        }
        return null;
    }

    public synchronized Object setByteProperty(String key, byte value) throws PropertyException {
        return Properties.setByteProperty(this, key, value);
    }

    public static Object setDoubleProperty(java.util.Properties properties, String key, double value) throws PropertyException {
        if (properties != null) {
            return properties.put(key, new Double(value));
        }
        return null;
    }

    public synchronized Object setDoubleProperty(String key, double value) throws PropertyException {
        return Properties.setDoubleProperty(this, key, value);
    }

    public static Object setFloatProperty(java.util.Properties properties, String key, float value) throws PropertyException {
        if (properties != null) {
            return properties.put(key, new Float(value));
        }
        return null;
    }

    public synchronized Object setFloatProperty(String key, float value) throws PropertyException {
        return Properties.setFloatProperty(this, key, value);
    }

    public static Object setIntProperty(java.util.Properties properties, String key, int value) throws PropertyException {
        if (properties != null) {
            return properties.put(key, new Integer(value));
        }
        return null;
    }

    public synchronized Object setIntProperty(String key, int value) throws PropertyException {
        return Properties.setIntProperty(this, key, value);
    }

    public void setKeyValidator(Validator keyValidator) {
        this.keyValidator = keyValidator;
    }

    public static Object setLongProperty(java.util.Properties properties, String key, long value) throws PropertyException {
        if (properties != null) {
            return properties.put(key, new Long(value));
        }
        return null;
    }

    public synchronized Object setLongProperty(String key, long value) throws PropertyException {
        return Properties.setLongProperty(this, key, value);
    }

    public static Object setObjectProperty(java.util.Properties properties, String key, Object value) throws PropertyException {
        if (properties != null) {
            return properties.put(key, value);
        }
        return null;
    }

    public synchronized Object setObjectProperty(String key, Object value) throws PropertyException {
        return Properties.setObjectProperty(this, key, value);
    }

    public synchronized Object setProperty(String key, String value) throws PropertyException {
        return this.setStringProperty(key, value);
    }

    public static Object setShortProperty(java.util.Properties properties, String key, short value) throws PropertyException {
        if (properties != null) {
            return properties.put(key, new Short(value));
        }
        return null;
    }

    public synchronized Object setShortProperty(String key, short value) throws PropertyException {
        return Properties.setShortProperty(this, key, value);
    }

    public static Object setStringProperty(java.util.Properties properties, String key, String value) throws PropertyException {
        if (properties != null) {
            return properties.put(key, value);
        }
        return null;
    }

    public synchronized Object setStringProperty(String key, String value) throws PropertyException {
        return Properties.setStringProperty(this, key, value);
    }

    public void setValueValidator(Validator valueValidator) {
        this.valueValidator = valueValidator;
    }

    private static void checkIfNull(Object value) {
        if (value == null) {
            throw new PropertyException("Cannot convert null values");
        }
    }

    private static boolean asBoolean(Object value) throws PropertyException {
        Properties.checkIfNull(value);
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new PropertyException("value is not a boolean: " + value);
    }

    private static byte asByte(Object value) throws PropertyException {
        Properties.checkIfNull(value);
        if (value instanceof String) {
            try {
                return Byte.valueOf((String)value);
            }
            catch (NumberFormatException exception) {
                throw new PropertyException("value is not a byte: " + value);
            }
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        throw new PropertyException("value is not a byte: " + value);
    }

    private static double asDouble(Object value) throws PropertyException {
        Properties.checkIfNull(value);
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException exception) {
                throw new PropertyException("value is not a double: " + value);
            }
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        throw new PropertyException("value is not a double: " + value);
    }

    private static float asFloat(Object value) throws PropertyException {
        Properties.checkIfNull(value);
        if (value instanceof String) {
            try {
                return Float.valueOf((String)value).floatValue();
            }
            catch (NumberFormatException exception) {
                throw new PropertyException("value is not a float: " + value);
            }
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        throw new PropertyException("value is not a float: " + value);
    }

    private static int asInt(Object value) throws PropertyException {
        Properties.checkIfNull(value);
        if (value instanceof String) {
            try {
                return Integer.valueOf((String)value);
            }
            catch (NumberFormatException exception) {
                throw new PropertyException("value is not an int: " + value);
            }
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        throw new PropertyException("value is not an int: " + value);
    }

    private static long asLong(Object value) throws PropertyException {
        Properties.checkIfNull(value);
        if (value instanceof String) {
            try {
                return Long.valueOf((String)value);
            }
            catch (NumberFormatException exception) {
                throw new PropertyException("value is not a long: " + value);
            }
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        throw new PropertyException("value is not a long: " + value);
    }

    private static short asShort(Object value) throws PropertyException {
        Properties.checkIfNull(value);
        if (value instanceof String) {
            try {
                return Short.valueOf((String)value);
            }
            catch (NumberFormatException exception) {
                throw new PropertyException("value is not a short: " + value);
            }
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        throw new PropertyException("value is not a short: " + value);
    }

    private void validateKey(Object key) throws PropertyException {
        if (this.keyValidator != null && !this.keyValidator.isValid(key)) {
            throw new PropertyException("invalid key: " + key);
        }
    }

    private void validateValue(Object value) throws PropertyException {
        if (this.valueValidator != null && !this.valueValidator.isValid(value)) {
            throw new PropertyException("invalid value: " + value);
        }
    }

    public static class PropertyValueValidator
    implements Validator {
        public boolean isValid(Object object) {
            return object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String;
        }
    }

    public static class PropertyKeyValidator
    implements Validator {
        public boolean isValid(Object object) {
            return object instanceof String;
        }
    }
}

