/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.CompositeFactory;
import de.hunsicker.jalopy.language.DeclarationType;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.JavaNodeModifier;
import de.hunsicker.jalopy.language.NodeComparator;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.VariableDefNodeComparator;
import de.hunsicker.jalopy.language.antlr.ExtendedToken;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

final class SortTransformation
implements Transformation {
    private static final String EMPTY_STRING = "".intern();
    private final NodeComparator _defaultComparator = new NodeComparator();
    private final VariableDefNodeComparator _variablesComparator = new VariableDefNodeComparator();
    CompositeFactory _factory = null;

    public SortTransformation(CompositeFactory factory) {
        this._factory = factory;
    }

    public void apply(AST tree) throws TransformationException {
        Convention settings = Convention.getInstance();
        boolean sortModifiers = settings.getBoolean(ConventionKeys.SORT_MODIFIERS, false);
        boolean sortBeanNames = settings.getBoolean(ConventionKeys.SORT_METHOD_BEAN, false);
        this._defaultComparator.setBeanSorting(sortBeanNames);
        this._defaultComparator.setModifierSorting(sortModifiers);
        this._variablesComparator.setModifierSorting(sortModifiers);
        this.sort(tree, this._defaultComparator);
    }

    public void sort(AST tree, Comparator comp) {
        if (tree == null) {
            return;
        }
        AST first = null;
        AST child = tree.getFirstChild();
        block3: while (child != null) {
            switch (child.getType()) {
                case 19: 
                case 20: {
                    first = child;
                    break block3;
                }
                default: {
                    child = child.getNextSibling();
                }
            }
        }
        AST declaration = first;
        while (declaration != null) {
            this.sortDeclarations(declaration, comp, 1);
            declaration = declaration.getNextSibling();
        }
    }

    private boolean isStatic(AST node) {
        return JavaNodeModifier.isStatic(JavaNodeHelper.getFirstChild(node, 10));
    }

    private void addChild(JavaNode node, JavaNode sibling) {
        node.setNextSibling(sibling);
        sibling.setPreviousSibling(node);
        sibling.setNextSibling(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JavaNode addSiblings(List nodes, JavaNode node, boolean addSeparator, int indent, int maxwidth) {
        JavaNode cur = node;
        if (nodes.size() <= 0) return node;
        JavaNode next = (JavaNode)nodes.get(0);
        this.addChild(cur, next);
        cur = next;
        if (addSeparator) {
            ExtendedToken comment = this._factory.getExtendedTokenFactory().create(69, EMPTY_STRING);
            if (next.hasCommentsBefore()) {
                ExtendedToken tok = (ExtendedToken)next.getHiddenBefore();
                while (tok != null) {
                    if (tok.getHiddenBefore() == null) {
                        tok.setHiddenBefore(comment);
                        comment.setHiddenAfter(tok);
                        break;
                    }
                    tok = (ExtendedToken)tok.getHiddenBefore();
                }
            } else {
                next.setHiddenBefore(comment);
            }
            Convention settings = Convention.getInstance();
            String fillCharacter = settings.get(ConventionKeys.SEPARATOR_FILL_CHARACTER, "\u00b7");
            switch (next.getType()) {
                case 15: {
                    if (this.isStatic(cur)) {
                        this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_STATIC_VAR_INIT, "Static variables/initializers"), fillCharacter, indent, maxwidth);
                        break;
                    }
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_INSTANCE_VAR, "Instance variables"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 14: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_METHOD, "Methods"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 13: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_CTOR, "Constructors"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 19: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_CLASS, "Inner classes"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 20: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_INTERFACE, "Inner Interfaces"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 17: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_STATIC_VAR_INIT, "Static variables/initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 16: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_INSTANCE_INIT, "Instance initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 51: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_ENUM_INIT, "Enumeration initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 52: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_ENUM_CONSTANT_INIT, "Enumeration constant initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 54: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_ANNOTATION_INIT, "Annotation initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected type -- " + cur);
                }
            }
        }
        int i = 1;
        int size = nodes.size();
        while (i < size) {
            JavaNode next2 = (JavaNode)nodes.get(i);
            this.addChild(cur, next2);
            cur = next2;
            ++i;
        }
        return cur;
    }

    private void fillComment(ExtendedToken comment, String text, String character, int indent, int maxwidth) {
        StringBuffer buf = new StringBuffer(maxwidth);
        buf.append("//~ ");
        buf.append(text);
        buf.append(' ');
        int i = text.length() + 4;
        int size = maxwidth - indent - 1;
        while (i < size) {
            buf.append(character);
            ++i;
        }
        comment.setText(buf.toString());
    }

    private AST sortDeclarations(AST node, Comparator comp, int level) {
        JavaNode tmp;
        JavaNode lcurly = null;
        switch (node.getType()) {
            case 19: {
                lcurly = (JavaNode)JavaNodeHelper.getFirstChild(node, 11);
                break;
            }
            case 20: {
                lcurly = (JavaNode)JavaNodeHelper.getFirstChild(node, 11);
                break;
            }
            case 54: {
                lcurly = (JavaNode)JavaNodeHelper.getFirstChild(node, 11);
            }
            case 51: {
                lcurly = (JavaNode)JavaNodeHelper.getFirstChild(node, 11);
                break;
            }
            default: {
                return node;
            }
        }
        switch (lcurly.getFirstChild().getType()) {
            case 8: {
                return node;
            }
        }
        ArrayList<AST> staticStuff = new ArrayList<AST>(3);
        ArrayList<AST> variables = new ArrayList<AST>();
        ArrayList<AST> initializers = new ArrayList<AST>(3);
        ArrayList<AST> ctors = new ArrayList<AST>(5);
        ArrayList<AST> methods = new ArrayList<AST>();
        ArrayList<AST> classes = new ArrayList<AST>(3);
        ArrayList<AST> interfaces = new ArrayList<AST>(3);
        ArrayList<AST> annotations = new ArrayList<AST>(3);
        ArrayList<AST> enums = new ArrayList<AST>(3);
        ArrayList<String> names = new ArrayList<String>();
        AST rcurly = null;
        AST child = lcurly.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 14: {
                    methods.add(child);
                    break;
                }
                case 15: {
                    if (this.isStatic(child)) {
                        staticStuff.add(child);
                        break;
                    }
                    names.add(JavaNodeHelper.getFirstChild(child, 79).getText());
                    variables.add(child);
                    break;
                }
                case 13: {
                    ctors.add(child);
                    break;
                }
                case 17: {
                    staticStuff.add(child);
                    break;
                }
                case 16: {
                    initializers.add(child);
                    break;
                }
                case 19: {
                    classes.add(this.sortDeclarations(child, comp, level + 1));
                    break;
                }
                case 20: {
                    interfaces.add(this.sortDeclarations(child, comp, level + 1));
                    break;
                }
                case 8: {
                    rcurly = child;
                    break;
                }
                case 54: {
                    annotations.add(child);
                    break;
                }
                case 51: {
                    enums.add(this.sortDeclarations(child, comp, level + 1));
                    break;
                }
                case 52: {
                    enums.add(child);
                    break;
                }
                case 74: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("cannot handle node -- " + child);
                }
            }
            child = child.getNextSibling();
        }
        Convention settings = Convention.getInstance();
        if (settings.getBoolean(ConventionKeys.SORT_VARIABLE, false)) {
            this._variablesComparator.names = names;
            Collections.sort(variables, this._variablesComparator);
            names.clear();
        }
        if (settings.getBoolean(ConventionKeys.SORT_CTOR, false)) {
            Collections.sort(ctors, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_METHOD, false)) {
            Collections.sort(methods, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_CLASS, false)) {
            Collections.sort(classes, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_INTERFACE, false)) {
            Collections.sort(interfaces, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_ENUM, false)) {
            Collections.sort(enums, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_ANNOTATION, false)) {
            Collections.sort(annotations, comp);
        }
        HashMap<String, ArrayList<AST>> nodes = new HashMap<String, ArrayList<AST>>(10, 1.0f);
        nodes.put(DeclarationType.STATIC_VARIABLE_INIT.getName(), staticStuff);
        nodes.put(DeclarationType.VARIABLE.getName(), variables);
        nodes.put(DeclarationType.INIT.getName(), initializers);
        nodes.put(DeclarationType.CTOR.getName(), ctors);
        nodes.put(DeclarationType.METHOD.getName(), methods);
        nodes.put(DeclarationType.INTERFACE.getName(), interfaces);
        nodes.put(DeclarationType.CLASS.getName(), classes);
        nodes.put(DeclarationType.ANNOTATION.getName(), annotations);
        nodes.put(DeclarationType.ENUM.getName(), enums);
        boolean addSeparator = false;
        addSeparator = level == 1 ? settings.getBoolean(ConventionKeys.COMMENT_INSERT_SEPARATOR, false) : settings.getBoolean(ConventionKeys.COMMENT_INSERT_SEPARATOR_RECURSIVE, false);
        String sortString = settings.get(ConventionKeys.SORT_ORDER, DeclarationType.getOrder());
        int maxwidth = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        int indent = settings.getInt(ConventionKeys.INDENT_SIZE, 4);
        JavaNode current = tmp = (JavaNode)this._factory.getJavaNodeFactory().create();
        StringTokenizer tokens = new StringTokenizer(sortString, "|");
        while (tokens.hasMoreTokens()) {
            String nextToken = tokens.nextToken();
            current = this.addSiblings((List)nodes.get(nextToken), current, addSeparator, indent * level, maxwidth);
        }
        current.setNextSibling(rcurly);
        JavaNode sibling = (JavaNode)tmp.getNextSibling();
        sibling.setPreviousSibling(lcurly);
        lcurly.setFirstChild(sibling);
        tmp.setNextSibling(null);
        current.setNextSibling(rcurly);
        staticStuff.clear();
        variables.clear();
        initializers.clear();
        ctors.clear();
        methods.clear();
        classes.clear();
        interfaces.clear();
        annotations.clear();
        enums.clear();
        names.clear();
        return node;
    }
}

