/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.env.SpringWebFlowInstantiationServlet;
import com.icesoft.faces.webapp.http.core.FlowExecutionHandler;
import com.icesoft.faces.webapp.http.core.FlowExecutorUtil;
import java.io.IOException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.context.portlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.portlet.FlowUrlHandler;
import org.springframework.webflow.context.portlet.PortletExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.executor.FlowExecutionResult;

public class PortletFlowExecutionHandler
implements FlowExecutionHandler {
    private static Log log = LogFactory.getLog((Class)PortletFlowExecutionHandler.class);
    private FlowExecutionResult result;
    private PortletExternalContext portletExternalContext;
    private PortletRequest request;
    private PortletResponse response;
    private FlowExecutorUtil flowExecutorUtil;
    private ExternalContext externalContext;
    private FlowUrlHandler flowUrlHandler;
    private FacesContext facesContext;

    public PortletFlowExecutionHandler(ExternalContext externalContext, FlowExecutionResult result, PortletExternalContext portletExternalContext, PortletRequest request, PortletResponse response, FacesContext facesContext) {
        this.externalContext = externalContext;
        this.result = result;
        this.portletExternalContext = portletExternalContext;
        this.request = request;
        this.response = response;
        this.facesContext = facesContext;
        this.flowUrlHandler = new DefaultFlowUrlHandler();
        this.flowExecutorUtil = new FlowExecutorUtil(SpringWebFlowInstantiationServlet.getFlowExecutor(), (org.springframework.webflow.context.ExternalContext)portletExternalContext);
    }

    public void handleFlowExecutionResult() throws IOException {
        if (this.result.isPaused()) {
            if (this.portletExternalContext.getFlowExecutionRedirectRequested()) {
                this.sendFlowExecutionRedirect(this.result, this.portletExternalContext, this.request, this.response);
            }
            if (this.portletExternalContext.getFlowDefinitionRedirectRequested()) {
                this.sendFlowDefinitionRedirect(this.result, this.portletExternalContext, this.request, this.response);
            } else if (this.portletExternalContext.getExternalRedirectRequested()) {
                this.sendExternalRedirect(this.portletExternalContext.getExternalRedirectUrl(), this.request, this.response);
            }
        } else if (this.result.isEnded()) {
            if (this.portletExternalContext.getFlowDefinitionRedirectRequested()) {
                this.sendFlowDefinitionRedirect(this.result, this.portletExternalContext, this.request, this.response);
            } else if (this.portletExternalContext.getExternalRedirectRequested()) {
                this.sendExternalRedirect(this.portletExternalContext.getExternalRedirectUrl(), this.request, this.response);
            } else {
                this.defaultHandleExecutionOutcome(this.portletExternalContext, this.result.getFlowId(), this.result.getOutcome(), this.request, this.response);
            }
        } else {
            throw new IllegalStateException("Execution result should have been one of [paused] or [ended]");
        }
    }

    protected void defaultHandleExecutionOutcome(PortletExternalContext portletExternalContext, String flowId, FlowExecutionOutcome outcome, PortletRequest request, PortletResponse response) throws IOException {
        MutableAttributeMap input = this.flowExecutorUtil.defaultFlowExecutionInputMapPortlet(request);
        this.flowExecutorUtil.launchExecution(input, flowId);
    }

    private void sendFlowExecutionRedirect(FlowExecutionResult result, PortletExternalContext portletExternalContext, PortletRequest request, PortletResponse response) throws IOException {
        String url = this.flowUrlHandler.createFlowExecutionUrl(result.getFlowId(), this.flowUrlHandler.getFlowExecutionKey(request), (RenderResponse)request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending flow execution redirect to '" + url + "'"));
        }
        this.sendRedirect(url, request, response);
    }

    private void sendFlowDefinitionRedirect(FlowExecutionResult result, PortletExternalContext portletExternalContext, PortletRequest request, PortletResponse response) throws IOException {
        String newFlowId = portletExternalContext.getFlowRedirectFlowId();
        MutableAttributeMap input = portletExternalContext.getFlowRedirectFlowInput();
        if (result.isPaused()) {
            input.put("refererExecution", (Object)result.getPausedKey());
        }
        this.flowExecutorUtil.launchExecution(input, newFlowId);
    }

    private void sendExternalRedirect(String location, PortletRequest request, PortletResponse response) throws IOException {
        this.externalContext.redirect(location);
    }

    private void sendRedirect(String url, PortletRequest request, PortletResponse response) throws IOException {
    }

    public PortletExternalContext getPortletExternalContext() {
        return this.portletExternalContext;
    }
}

