/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.io;

import de.hunsicker.io.Filters;
import de.hunsicker.util.ResourceBundleFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class DirectoryScanner
implements Runnable {
    private static final String BUNDLE_NAME = "de.hunsicker.io.Bundle";
    private Filters _filters;
    volatile Object _lock = new Object();
    private Queue _queue = new Queue();
    private File[] _dirs;
    private boolean _finished;
    private int _levels = 0;

    public DirectoryScanner() {
        this(System.getProperty("user.dir"), 0);
    }

    public DirectoryScanner(String directory) {
        this(directory, Integer.MAX_VALUE);
    }

    public DirectoryScanner(String directory, int levels) {
        this(new File(directory), levels);
    }

    public DirectoryScanner(File directory) {
        this(new File(directory.getAbsolutePath()), Integer.MAX_VALUE);
    }

    public DirectoryScanner(File directory, int levels) {
        this(DirectoryScanner.addToList(directory), levels);
    }

    public DirectoryScanner(Set directories) {
        this(directories, Integer.MAX_VALUE);
    }

    public DirectoryScanner(Set directories, int levels) {
        this.setTargets(directories);
        this._levels = levels;
        this._filters = new Filters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this._lock;
        synchronized (object) {
            return this._queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFiles() {
        Object object = this._lock;
        synchronized (object) {
            return this._queue.toArray();
        }
    }

    public void setFilterPolicy(int policy) {
        if (this._filters != null) {
            this._filters.setPolicy(policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Object object = this._lock;
        synchronized (object) {
            return this._finished;
        }
    }

    public void setMaxLevels(int level) {
        if (this.isFinished()) {
            throw new IllegalStateException(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("SCANNER_RUNNING"));
        }
        this._levels = level;
    }

    public int getMaxLevels() {
        return this._levels;
    }

    public void setTargets(Collection targets) {
        if (targets instanceof HashSet) {
            this.setTargets((HashSet)targets);
        } else {
            this.setTargets(new HashSet(targets));
        }
    }

    public void setTargets(Set targets) {
        if (targets == null) {
            throw new NullPointerException();
        }
        if (this.isFinished()) {
            throw new IllegalStateException(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("SCANNER_RUNNING"));
        }
        HashSet copy = new HashSet(targets);
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            Object file = it.next();
            if (file instanceof String) {
                targets.remove(file);
                file = new File((String)file);
                targets.add(file);
            }
            if (((File)file).isDirectory()) continue;
            this._queue.push((File)file);
            targets.remove(file);
        }
        this._dirs = new File[targets.size()];
        targets.toArray(this._dirs);
    }

    public void addFilter(FilenameFilter filter) {
        if (this.isFinished()) {
            throw new IllegalStateException(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("SCANNER_RUNNING"));
        }
        this._filters.addFilter(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        Object object = this._lock;
        synchronized (object) {
            return this._queue.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File pop() {
        Object object = this._lock;
        synchronized (object) {
            return this._queue.pop();
        }
    }

    public void removeFilter(FilenameFilter filter) {
        if (this.isFinished()) {
            throw new IllegalStateException(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("SCANNER_RUNNING"));
        }
        this._filters.removeFilter(filter);
    }

    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this._finished = false;
            int i = 0;
            while (i < this._dirs.length) {
                if (this._dirs[i].isDirectory()) {
                    this.scanDirectory(this._dirs[i]);
                }
                ++i;
            }
        }
        finally {
            Object object = this._lock;
            synchronized (object) {
                this._finished = true;
            }
            DirectoryScanner directoryScanner = this;
            synchronized (directoryScanner) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File take() throws InterruptedException {
        Object object = this._lock;
        synchronized (object) {
            while (this._queue.isEmpty()) {
                this._lock.wait();
            }
        }
        return this.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        block6: {
            if (this.isFinished()) break block6;
            try {
                DirectoryScanner directoryScanner = this;
                synchronized (directoryScanner) {
                    while (!this.isFinished()) {
                        super.wait();
                    }
                }
            }
            catch (Exception ex) {}
        }
    }

    private static Set addToList(File directory) {
        HashSet<File> dir = new HashSet<File>(2);
        dir.add(directory);
        return dir;
    }

    private void scanDirectory(File dir) {
        this.scanDirectory(dir, dir.getPath(), 0);
    }

    private void scanDirectory(File dir, String rootDir, int depth) {
        File[] dirEntries = null;
        dirEntries = dir.listFiles(this._filters);
        if (dirEntries != null && depth <= this._levels) {
            int i = 0;
            while (i < dirEntries.length) {
                if (dirEntries[i].isDirectory()) {
                    this.scanDirectory(dirEntries[i], rootDir, depth + 1);
                } else {
                    this._queue.push(dirEntries[i]);
                }
                ++i;
            }
        }
    }

    private class Queue {
        LinkedList list;

        public Queue() {
            this.list = new LinkedList();
        }

        private Queue(LinkedList list) {
            this.list = new LinkedList(list);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Iterator iterator() {
            Queue stack = new Queue(this.list);
            return stack.list.iterator();
        }

        public File pop() {
            return (File)this.list.removeLast();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(File file) {
            this.list.add(file);
            Object object = DirectoryScanner.this._lock;
            synchronized (object) {
                DirectoryScanner.this._lock.notify();
            }
        }

        public int size() {
            return this.list.size();
        }

        public File[] toArray() {
            Queue stack = new Queue(this.list);
            File[] files = new File[stack.list.size()];
            stack.list.toArray(files);
            return files;
        }
    }
}

