/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.util.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.soap.Text;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.util.impl.NamespaceContextFromDOM;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XMLStreamReaderFromDOM
implements XMLStreamReader {
    private Node cursor;
    private Stack<Node> nextCursorStack = new Stack();
    private Node root;
    private int event = 7;
    private Node nextCursor = null;
    private int nextEvent = -1;
    private NamespaceContextFromDOM cacheNCI = null;
    private Element cacheNCIKey = null;
    private List cacheND = null;
    private Element cacheNDKey = null;
    private DummyLocation dummyLocation = new DummyLocation();

    public XMLStreamReaderFromDOM(Element envelope) {
        this.cursor = this.root = envelope;
    }

    public Object getProperty(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException(Messages.getMessage((String)"XMLSRErr1"));
        }
        return null;
    }

    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            throw new XMLStreamException(Messages.getMessage((String)"XMLSRErr2"));
        }
        this.getNext();
        this.cursor = this.nextCursor;
        this.event = this.nextEvent;
        return this.event;
    }

    public void require(int event, String namespace, String localPart) throws XMLStreamException {
        try {
            if (event != this.event) {
                throw new XMLStreamException(Messages.getMessage((String)"XMLSRErr3", (String)String.valueOf(event), (String)String.valueOf(this.event)));
            }
            if (namespace != null && !namespace.equals(this.cursor.getNamespaceURI())) {
                throw new XMLStreamException(Messages.getMessage((String)"XMLSRErr3", (String)namespace, (String)this.cursor.getNamespaceURI()));
            }
            if (localPart != null && !localPart.equals(this.cursor.getLocalName())) {
                throw new XMLStreamException(Messages.getMessage((String)"XMLSRErr3", (String)localPart, (String)this.cursor.getLocalName()));
            }
        }
        catch (XMLStreamException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public String getElementText() throws XMLStreamException {
        if (this.event == 1) {
            this.next();
            StringBuffer buffer = new StringBuffer();
            while (this.event != 2) {
                if (this.event == 4 || this.event == 12 || this.event == 6 || this.event == 9) {
                    buffer.append(this.getText());
                } else if (this.event != 3 && this.event != 5) {
                    throw new XMLStreamException(Messages.getMessage((String)"XMLSRErr4", (String)"getElementText()"));
                }
                this.next();
            }
            return buffer.toString();
        }
        throw new XMLStreamException(Messages.getMessage((String)"XMLSRErr4", (String)"getElementText()"));
    }

    public int nextTag() throws XMLStreamException {
        this.next();
        while (this.event == 4 && this.isWhiteSpace() || this.event == 12 && this.isWhiteSpace() || this.event == 6 || this.event == 3 || this.event == 5) {
            this.event = this.next();
        }
        if (this.event == 1 || this.event == 2) {
            return this.event;
        }
        throw new XMLStreamException(Messages.getMessage((String)"XMLSRErr4", (String)"nextTag()"));
    }

    public boolean hasNext() throws XMLStreamException {
        return this.event != 8;
    }

    public void close() throws XMLStreamException {
    }

    public String getNamespaceURI(String prefix) {
        if (this.cursor instanceof Element) {
            return this.getNamespaceContext().getNamespaceURI(prefix);
        }
        throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr4", (String)"getNamespaceURI(String)"));
    }

    public boolean isStartElement() {
        return this.event == 1;
    }

    public boolean isEndElement() {
        return this.event == 2;
    }

    public boolean isCharacters() {
        return this.event == 4;
    }

    public boolean isWhiteSpace() {
        if (this.event == 4 || this.event == 12) {
            String value = ((CharacterData)this.cursor).getData();
            StringTokenizer st = new StringTokenizer(value);
            return !st.hasMoreTokens();
        }
        return false;
    }

    private List getAttributes() {
        if (this.event == 1) {
            ArrayList<Attr> attrs = new ArrayList<Attr>();
            NamedNodeMap map = ((Element)this.cursor).getAttributes();
            if (map != null) {
                for (int i = 0; i < map.getLength(); ++i) {
                    Attr attr = (Attr)map.item(i);
                    if (attr.getName().equals("xmlns") || attr.getName().startsWith("xmlns:")) continue;
                    attrs.add(attr);
                }
            }
            return attrs;
        }
        throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr4", (String)"getAttributes()"));
    }

    public String getAttributeValue(String namespace, String localPart) {
        if (this.event == 1) {
            return ((Element)this.cursor).getAttributeNS(namespace, localPart);
        }
        throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr4", (String)"getAttributeValue(String, String)"));
    }

    public int getAttributeCount() {
        return this.getAttributes().size();
    }

    public QName getAttributeName(int index) {
        Attr attr = (Attr)this.getAttributes().get(index);
        return new QName(attr.getNamespaceURI(), attr.getLocalName());
    }

    public String getAttributeNamespace(int index) {
        Attr attr = (Attr)this.getAttributes().get(index);
        return attr.getNamespaceURI();
    }

    public String getAttributeLocalName(int index) {
        Attr attr = (Attr)this.getAttributes().get(index);
        return attr.getLocalName();
    }

    public String getAttributePrefix(int index) {
        Attr attr = (Attr)this.getAttributes().get(index);
        return attr.getPrefix();
    }

    public String getAttributeType(int index) {
        Attr attr = (Attr)this.getAttributes().get(index);
        return attr.getSchemaTypeInfo().getTypeName();
    }

    public String getAttributeValue(int index) {
        Attr attr = (Attr)this.getAttributes().get(index);
        return attr.getValue();
    }

    public boolean isAttributeSpecified(int arg0) {
        return true;
    }

    public int getNamespaceCount() {
        if (this.cursor instanceof Element) {
            List list = this.getNamespaceDeclarations();
            return list.size();
        }
        throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr4", (String)"getNamespaceCount()"));
    }

    public String getNamespacePrefix(int index) {
        if (this.cursor instanceof Element) {
            List list = this.getNamespaceDeclarations();
            return ((NamespaceDeclare)list.get(index)).getPrefix();
        }
        throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr4", (String)"getNamespacePrefix(int)"));
    }

    public String getNamespaceURI(int index) {
        if (this.cursor instanceof Element) {
            List list = this.getNamespaceDeclarations();
            return ((NamespaceDeclare)list.get(index)).getURI();
        }
        throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr4", (String)"getNamespaceURI(int)"));
    }

    public NamespaceContext getNamespaceContext() {
        Element element = null;
        if (this.cursor instanceof Element) {
            element = (Element)this.cursor;
        } else {
            Element parent = (Element)this.cursor.getParentNode();
            if (parent == null) {
                parent = (Element)this.nextCursorStack.peek();
            }
            element = (Element)this.cursor.getParentNode();
        }
        if (element == this.cacheNCIKey) {
            return this.cacheNCI;
        }
        this.cacheNCIKey = element;
        this.cacheNCI = new NamespaceContextFromDOM(element);
        return this.cacheNCI;
    }

    public int getEventType() {
        return this.event;
    }

    public String getText() {
        if (this.event == 4 || this.event == 12 || this.event == 5) {
            return ((CharacterData)this.cursor).getData();
        }
        throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr4", (String)"getText()"));
    }

    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        String value = this.getText();
        int sourceEnd = sourceStart + length;
        if (value.length() < sourceEnd) {
            sourceEnd = value.length();
        }
        value.getChars(sourceStart, sourceEnd, target, targetStart);
        return sourceEnd - sourceStart;
    }

    public int getTextStart() {
        return 0;
    }

    public int getTextLength() {
        return this.getText().length();
    }

    public String getEncoding() {
        return null;
    }

    public boolean hasText() {
        return this.event == 4 || this.event == 12 || this.event == 5;
    }

    public Location getLocation() {
        return this.dummyLocation;
    }

    public QName getName() {
        if (this.cursor instanceof Element) {
            return new QName(this.cursor.getNamespaceURI(), this.cursor.getLocalName());
        }
        throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr4", (String)"getName()"));
    }

    public String getLocalName() {
        if (this.cursor instanceof Element) {
            return this.cursor.getLocalName();
        }
        throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr4", (String)"getLocalName()"));
    }

    public boolean hasName() {
        return this.isStartElement() || this.isEndElement();
    }

    public String getNamespaceURI() {
        if (this.cursor instanceof Element) {
            return this.cursor.getNamespaceURI();
        }
        return null;
    }

    public String getPrefix() {
        if (this.cursor instanceof Element) {
            return this.cursor.getPrefix();
        }
        return null;
    }

    public String getVersion() {
        return null;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getPITarget() {
        return null;
    }

    public String getPIData() {
        return null;
    }

    private void getNext() throws IllegalStateException {
        switch (this.event) {
            case 7: {
                this.nextCursor = this.cursor;
                this.nextEvent = 1;
                break;
            }
            case 1: {
                if (this.cursor.getFirstChild() != null) {
                    this.nextCursorStack.push(this.nextCursor);
                    this.nextCursor = this.cursor.getFirstChild();
                    this.nextEvent = this.startEvent(this.nextCursor);
                    break;
                }
                this.nextEvent = 2;
                break;
            }
            case 10: {
                throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr5", (String)"ATTRIBUTE"));
            }
            case 13: {
                throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr5", (String)"NAMESPACE"));
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                if (this.cursor.getNextSibling() != null) {
                    this.nextCursor = this.cursor.getNextSibling();
                    this.nextEvent = this.startEvent(this.nextCursor);
                    break;
                }
                if (this.cursor == this.root) {
                    this.nextEvent = 8;
                    break;
                }
                this.nextCursor = this.nextCursorStack.pop();
                this.nextEvent = 2;
                break;
            }
            case 8: {
                this.nextCursor = null;
                this.nextEvent = -1;
            }
            default: {
                throw new IllegalStateException(Messages.getMessage((String)"XMLSRErr5", (String)String.valueOf(this.event)));
            }
        }
    }

    private int startEvent(Node node) {
        if (node instanceof ProcessingInstruction) {
            return 3;
        }
        if (node instanceof CDATASection) {
            return 12;
        }
        if (node instanceof Comment) {
            return 5;
        }
        if (node instanceof org.w3c.dom.Text) {
            if (node instanceof Text) {
                Text soapText = (Text)node;
                if (soapText.isComment()) {
                    return 5;
                }
                return 4;
            }
            return 4;
        }
        if (node instanceof Element) {
            return 1;
        }
        if (node instanceof Attr) {
            return 10;
        }
        if (node instanceof Document) {
            return 7;
        }
        if (node instanceof EntityReference) {
            return 9;
        }
        if (node instanceof DocumentType) {
            return 11;
        }
        return -1;
    }

    public List getNamespaceDeclarations() {
        Element element = null;
        if (!(this.cursor instanceof Element)) {
            return new ArrayList();
        }
        element = (Element)this.cursor;
        if (element == this.cacheNDKey) {
            return this.cacheND;
        }
        this.cacheNDKey = element;
        this.cacheND = new ArrayList();
        NamedNodeMap attrs = element.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                String name = attr.getNodeName();
                if (!name.startsWith("xmlns")) continue;
                String prefix = "";
                if (name.startsWith("xmlns:")) {
                    prefix = name.substring(6);
                }
                NamespaceDeclare nd = new NamespaceDeclare(prefix, attr.getNodeValue());
                this.cacheND.add(nd);
            }
        }
        return this.cacheND;
    }

    Node getNode() {
        return this.cursor;
    }

    class NamespaceDeclare {
        String prefix;
        String uri;

        NamespaceDeclare(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        String getPrefix() {
            return this.prefix;
        }

        String getURI() {
            return this.uri;
        }
    }

    private class DummyLocation
    implements Location {
        private DummyLocation() {
        }

        public int getLineNumber() {
            return -1;
        }

        public int getColumnNumber() {
            return 0;
        }

        public int getCharacterOffset() {
            return 0;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }
    }
}

