/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.JavaNodeModifier;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class References {
    public static final int SCOPE_CLASS = 2;
    public static final int SCOPE_DEFAULT = 1;
    private final LinkedList _scopesStack = new LinkedList();
    private final List _scopes = new ArrayList();
    final Map _variables = new HashMap();
    private final Scope _defaultScope;
    private Scope _curScope = this._defaultScope = new Scope();
    private final Set _identifiers = new HashSet(150);
    private final Set _types = new HashSet(30);

    public References() {
        this._scopesStack.addFirst(this._defaultScope);
    }

    public Map getVariables() {
        return this._variables;
    }

    public void addReference(String name, JavaNode node) {
        this._curScope.addReference(node, name);
        this._identifiers.add(name);
    }

    public void defineType(String name, JavaNode node) {
        this._types.add(name);
    }

    public void defineVariable(String name, JavaNode node) {
        this._curScope.addVariable(name, node);
        this._variables.put(node, null);
    }

    public void enterScope() {
        this.enterScope(1);
    }

    public void enterScope(int type) {
        Scope scope;
        this._curScope = scope = new Scope(this._curScope, type);
        this._scopesStack.addFirst(scope);
        this._scopes.add(scope);
    }

    public void leaveScope() {
        this._curScope = (Scope)this._scopesStack.getFirst();
        if (this._curScope == this._defaultScope) {
            // empty if block
        }
    }

    public void reset() {
        this._variables.clear();
        this._types.clear();
        this._identifiers.clear();
        this._scopesStack.clear();
        this._scopesStack.addFirst(this._defaultScope);
        this._scopes.clear();
        if (this._defaultScope.children != null) {
            this._defaultScope.children.clear();
        }
        this._curScope = this._defaultScope;
    }

    public void resolveReferences() {
        this._curScope = this._defaultScope;
        System.out.println("Resolving...");
        this._curScope.resolveReferences();
        Iterator i = this._variables.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            List references = (List)entry.getValue();
            JavaNode node = (JavaNode)entry.getKey();
            int modifierMask = JavaNodeModifier.valueOf(node);
            if (Modifier.isFinal(modifierMask) && Modifier.isStatic(modifierMask)) continue;
            if (references == null) {
                switch (node.getType()) {
                    case 15: {
                        JavaNode assign = (JavaNode)JavaNodeHelper.getFirstChild(node, 110);
                        if (assign != null) {
                            System.out.println("XXX:" + node.getStartLine() + ":" + node.getStartColumn() + ": Variable " + JavaNodeHelper.getFirstChild(node, 79).getText() + " is declared but never assigned");
                            break;
                        }
                        System.out.println("XXX:" + node.getStartLine() + ":" + node.getStartColumn() + ": Variable " + JavaNodeHelper.getFirstChild(node, 79).getText() + " is assigned but never accessed");
                    }
                }
                continue;
            }
            block3 : switch (node.getType()) {
                case 15: {
                    int usages = references.size();
                    if (usages == 1) {
                        JavaNode usage = (JavaNode)references.get(0);
                        switch (usage.getParent().getType()) {
                            case 110: {
                                switch (usage.getPreviousSibling().getType()) {
                                    case 110: {
                                        if (!Modifier.isPrivate(modifierMask)) break;
                                        System.out.println("XXX:" + node.getStartLine() + ":" + node.getStartColumn() + ": Variable " + JavaNodeHelper.getFirstChild(node, 79).getText() + " is assigned but never accessed (assigned at " + usage.getStartLine() + ":" + usage.getStartColumn() + ")");
                                    }
                                }
                                break block3;
                            }
                        }
                        if (Modifier.isFinal(modifierMask)) break;
                    }
                    if (Modifier.isFinal(modifierMask)) break;
                    JavaNode assign = (JavaNode)JavaNodeHelper.getFirstChild(node, 110);
                    int assignments = 0;
                    if (assign != null) {
                        JavaNode expr = (JavaNode)assign.getFirstChild();
                        switch (expr.getType()) {
                            case 33: {
                                if ("null".equals(expr.getFirstChild().getText())) break;
                                assignments = 1;
                            }
                        }
                    }
                    int j = 0;
                    int size = references.size();
                    block19: while (j < size) {
                        JavaNode n = (JavaNode)references.get(j);
                        switch (n.getParent().getType()) {
                            case 110: {
                                if (++assignments > 1) break block19;
                            }
                            default: {
                                ++j;
                            }
                        }
                    }
                    if (assignments != true) break;
                }
            }
        }
    }

    private class Scope {
        List children;
        Map references;
        Map variables;
        Scope parent;
        int type;

        public Scope(Scope parent, int type) {
            this.type = type;
            if (parent != null) {
                this.parent = parent;
                if (parent.children == null) {
                    parent.children = new ArrayList();
                }
                parent.children.add(this);
            }
        }

        Scope() {
        }

        public void addReference(JavaNode node, String name) {
            if (this.references == null) {
                this.references = new HashMap();
            }
            this.references.put(node, name);
        }

        public void addVariable(String name, JavaNode node) {
            if (this.variables == null) {
                this.variables = new HashMap();
            }
            this.variables.put(name, node);
        }

        public void resolveReferences() {
            this.resolveVariableReferences(this);
            if (this.children != null) {
                int i = 0;
                int size = this.children.size();
                while (i < size) {
                    Scope scope = (Scope)this.children.get(i);
                    scope.resolveReferences();
                    ++i;
                }
            }
        }

        private void resolveVariableReferences(Scope scope) {
            if (this.references != null && !this.references.isEmpty()) {
                if (scope.variables != null && !scope.variables.isEmpty()) {
                    Iterator i = this.references.entrySet().iterator();
                    block9: while (i.hasNext()) {
                        Map.Entry reference = i.next();
                        String refName = (String)reference.getValue();
                        JavaNode refNode = (JavaNode)reference.getKey();
                        int dot = refName.indexOf(46);
                        if (dot == -1) {
                            switch (refNode.getType()) {
                                case 32: {
                                    continue block9;
                                }
                            }
                        } else {
                            int referrer = refName.indexOf(".this.");
                            if (referrer == -1) {
                                block3 : switch (scope.type) {
                                    case 2: {
                                        if (refName.startsWith("this.")) {
                                            int nextDot = refName.indexOf(46, 5);
                                            switch (nextDot) {
                                                case -1: {
                                                    refName = refName.substring(5);
                                                    break block3;
                                                }
                                            }
                                            refName = refName.substring(5, nextDot);
                                            break;
                                        }
                                    }
                                    default: {
                                        refName = refName.substring(0, dot);
                                        break;
                                    }
                                }
                            } else if (scope.type == 2) {
                                refName = refName.substring(referrer + 6);
                            }
                        }
                        Iterator j = scope.variables.entrySet().iterator();
                        while (j.hasNext()) {
                            Map.Entry variable = j.next();
                            String varName = (String)variable.getKey();
                            if (!refName.equals(varName)) continue;
                            JavaNode varNode = (JavaNode)variable.getValue();
                            ArrayList<JavaNode> theReferences = (ArrayList<JavaNode>)References.this._variables.get(varNode);
                            if (theReferences == null) {
                                theReferences = new ArrayList<JavaNode>();
                                References.this._variables.put(varNode, theReferences);
                            }
                            theReferences.add(refNode);
                            i.remove();
                        }
                    }
                }
                if (scope.parent != null && !this.references.isEmpty()) {
                    this.resolveVariableReferences(scope.parent);
                }
            }
        }
    }
}

