/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.ServerTrustManager;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class XMPPConnection {
    public static boolean DEBUG_ENABLED = false;
    private static final Set<ConnectionCreationListener> connectionEstablishedListeners = new CopyOnWriteArraySet<ConnectionCreationListener>();
    private static AtomicInteger connectionCounter = new AtomicInteger(0);
    private SmackDebugger debugger = null;
    String host;
    int port;
    Socket socket;
    String serviceName;
    int connectionCounterValue = connectionCounter.getAndIncrement();
    String connectionID = null;
    private String user = null;
    private boolean connected = false;
    private boolean authenticated = false;
    private boolean wasAuthenticated = false;
    private boolean anonymous = false;
    private boolean usingTLS = false;
    PacketWriter packetWriter;
    PacketReader packetReader;
    Roster roster = null;
    private AccountManager accountManager = null;
    private SASLAuthentication saslAuthentication = new SASLAuthentication(this);
    Writer writer;
    Reader reader;
    private Collection compressionMethods;
    private boolean usingCompression;
    private ConnectionConfiguration configuration;
    private ChatManager chatManager;

    public XMPPConnection(String serviceName) {
        ConnectionConfiguration config = new ConnectionConfiguration(serviceName);
        config.setCompressionEnabled(false);
        config.setSASLAuthenticationEnabled(true);
        config.setDebuggerEnabled(DEBUG_ENABLED);
        this.configuration = config;
    }

    public XMPPConnection(ConnectionConfiguration config) {
        this.configuration = config;
    }

    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        return this.connectionID;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        return this.user;
    }

    public void login(String username, String password) throws XMPPException {
        this.login(username, password, "Smack");
    }

    public synchronized void login(String username, String password, String resource) throws XMPPException {
        this.login(username, password, resource, true);
    }

    public synchronized void login(String username, String password, String resource, boolean sendPresence) throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        username = username.toLowerCase().trim();
        String response = this.configuration.isSASLAuthenticationEnabled() && this.saslAuthentication.hasNonAnonymousAuthentication() ? this.saslAuthentication.authenticate(username, password, resource) : new NonSASLAuthentication(this).authenticate(username, password, resource);
        if (response != null) {
            this.user = response;
            this.serviceName = StringUtils.parseServer(response);
        } else {
            this.user = username + "@" + this.serviceName;
            if (resource != null) {
                this.user = this.user + "/" + resource;
            }
        }
        if (this.configuration.isCompressionEnabled()) {
            this.useCompression();
        }
        if (this.roster == null) {
            this.roster = new Roster(this);
        }
        this.roster.reload();
        if (sendPresence) {
            this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        }
        this.authenticated = true;
        this.anonymous = false;
        this.getConfiguration().setLoginInfo(username, password, resource, sendPresence);
        if (this.configuration.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    public synchronized void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        String response = this.configuration.isSASLAuthenticationEnabled() && this.saslAuthentication.hasAnonymousAuthentication() ? this.saslAuthentication.authenticateAnonymously() : new NonSASLAuthentication(this).authenticateAnonymously();
        this.user = response;
        this.serviceName = StringUtils.parseServer(response);
        if (this.configuration.isCompressionEnabled()) {
            this.useCompression();
        }
        this.roster = null;
        this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        this.authenticated = true;
        this.anonymous = true;
        if (this.configuration.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Roster getRoster() {
        if (this.roster == null) {
            return null;
        }
        if (!this.roster.rosterInitialized) {
            try {
                Roster roster = this.roster;
                synchronized (roster) {
                    long now;
                    long start = System.currentTimeMillis();
                    for (long waitTime = (long)SmackConfiguration.getPacketReplyTimeout(); !this.roster.rosterInitialized && waitTime > 0L; waitTime -= now - start) {
                        this.roster.wait(waitTime);
                        now = System.currentTimeMillis();
                        start = now;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.roster;
    }

    public synchronized AccountManager getAccountManager() {
        if (this.accountManager == null) {
            this.accountManager = new AccountManager(this);
        }
        return this.accountManager;
    }

    public synchronized ChatManager getChatManager() {
        if (this.chatManager == null) {
            this.chatManager = new ChatManager(this);
        }
        return this.chatManager;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSecureConnection() {
        return this.isUsingTLS();
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    protected void shutdown(Presence unavailablePresence) {
        this.packetWriter.sendPacket(unavailablePresence);
        this.setWasAuthenticated(this.authenticated);
        this.authenticated = false;
        this.connected = false;
        this.packetReader.shutdown();
        this.packetWriter.shutdown();
        try {
            Thread.sleep(150L);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.writer = null;
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saslAuthentication.init();
    }

    public void disconnect() {
        this.disconnect(new Presence(Presence.Type.unavailable));
    }

    public void disconnect(Presence unavailablePresence) {
        if (this.packetReader == null || this.packetWriter == null) {
            return;
        }
        this.shutdown(unavailablePresence);
        if (this.roster != null) {
            this.roster.cleanup();
            this.roster = null;
        }
        this.wasAuthenticated = false;
        this.packetWriter.cleanup();
        this.packetWriter = null;
        this.packetReader.cleanup();
        this.packetReader = null;
    }

    public void sendPacket(Packet packet) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (packet == null) {
            throw new NullPointerException("Packet is null.");
        }
        this.packetWriter.sendPacket(packet);
    }

    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetReader.addPacketListener(packetListener, packetFilter);
    }

    public void removePacketListener(PacketListener packetListener) {
        this.packetReader.removePacketListener(packetListener);
    }

    public void addPacketWriterListener(PacketListener packetListener, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetWriter.addPacketListener(packetListener, packetFilter);
    }

    public void removePacketWriterListener(PacketListener packetListener) {
        this.packetWriter.removePacketListener(packetListener);
    }

    public void addPacketWriterInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        this.packetWriter.addPacketInterceptor(packetInterceptor, packetFilter);
    }

    public void removePacketWriterInterceptor(PacketInterceptor packetInterceptor) {
        this.packetWriter.removePacketInterceptor(packetInterceptor);
    }

    public PacketCollector createPacketCollector(PacketFilter packetFilter) {
        return this.packetReader.createPacketCollector(packetFilter);
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (connectionListener == null) {
            return;
        }
        if (!this.packetReader.connectionListeners.contains(connectionListener)) {
            this.packetReader.connectionListeners.add(connectionListener);
        }
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.packetReader.connectionListeners.remove(connectionListener);
    }

    public static void addConnectionCreationListener(ConnectionCreationListener connectionCreationListener) {
        connectionEstablishedListeners.add(connectionCreationListener);
    }

    public static void removeConnectionCreationListener(ConnectionCreationListener connectionCreationListener) {
        connectionEstablishedListeners.remove(connectionCreationListener);
    }

    private void connectUsingConfiguration(ConnectionConfiguration config) throws XMPPException {
        this.host = config.getHost();
        this.port = config.getPort();
        try {
            this.socket = config.getSocketFactory() == null ? new Socket(this.host, this.port) : config.getSocketFactory().createSocket(this.host, this.port);
        }
        catch (UnknownHostException uhe) {
            String errorMessage = "Could not connect to " + this.host + ":" + this.port + ".";
            throw new XMPPException(errorMessage, new XMPPError(XMPPError.Condition.remote_server_timeout, errorMessage), uhe);
        }
        catch (IOException ioe) {
            String errorMessage = "XMPPError connecting to " + this.host + ":" + this.port + ".";
            throw new XMPPException(errorMessage, new XMPPError(XMPPError.Condition.remote_server_error, errorMessage), ioe);
        }
        this.serviceName = config.getServiceName();
        this.initConnection();
    }

    private void initConnection() throws XMPPException {
        boolean isFirstInitialization;
        boolean bl = isFirstInitialization = this.packetReader == null || this.packetWriter == null;
        if (!isFirstInitialization) {
            this.usingCompression = false;
        }
        this.initReaderAndWriter();
        try {
            if (isFirstInitialization) {
                this.packetWriter = new PacketWriter(this);
                this.packetReader = new PacketReader(this);
                if (this.configuration.isDebuggerEnabled()) {
                    this.packetReader.addPacketListener(this.debugger.getReaderListener(), null);
                    if (this.debugger.getWriterListener() != null) {
                        this.packetWriter.addPacketListener(this.debugger.getWriterListener(), null);
                    }
                }
            } else {
                this.packetWriter.init();
                this.packetReader.init();
            }
            this.packetWriter.startup();
            this.packetReader.startup();
            this.connected = true;
            this.packetWriter.startKeepAliveProcess();
            if (isFirstInitialization) {
                for (ConnectionCreationListener listener : connectionEstablishedListeners) {
                    listener.connectionCreated(this);
                }
            } else {
                this.packetReader.notifyReconnection();
            }
        }
        catch (XMPPException ex) {
            if (this.packetWriter != null) {
                try {
                    this.packetWriter.shutdown();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                this.packetWriter = null;
            }
            if (this.packetReader != null) {
                try {
                    this.packetReader.shutdown();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                this.packetReader = null;
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                this.writer = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.socket = null;
            }
            this.setWasAuthenticated(this.authenticated);
            this.authenticated = false;
            this.connected = false;
            throw ex;
        }
    }

    private void initReaderAndWriter() throws XMPPException {
        try {
            if (!this.usingCompression) {
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
            } else {
                try {
                    Class<?> zoClass = Class.forName("com.jcraft.jzlib.ZOutputStream");
                    Constructor<?> constructor = zoClass.getConstructor(OutputStream.class, Integer.TYPE);
                    Object out = constructor.newInstance(this.socket.getOutputStream(), 9);
                    Method method = zoClass.getMethod("setFlushMode", Integer.TYPE);
                    method.invoke(out, 2);
                    this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                    Class<?> ziClass = Class.forName("com.jcraft.jzlib.ZInputStream");
                    constructor = ziClass.getConstructor(InputStream.class);
                    Object in = constructor.newInstance(this.socket.getInputStream());
                    method = ziClass.getMethod("setFlushMode", Integer.TYPE);
                    method.invoke(in, 2);
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                }
            }
        }
        catch (IOException ioe) {
            throw new XMPPException("XMPPError establishing connection with server.", new XMPPError(XMPPError.Condition.remote_server_error, "XMPPError establishing connection with server."), ioe);
        }
        if (this.configuration.isDebuggerEnabled()) {
            if (this.debugger == null) {
                String className = null;
                try {
                    className = System.getProperty("smack.debuggerClass");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                Class<?> debuggerClass = null;
                if (className != null) {
                    try {
                        debuggerClass = Class.forName(className);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (debuggerClass == null) {
                    try {
                        debuggerClass = Class.forName("org.jivesoftware.smackx.debugger.EnhancedDebugger");
                    }
                    catch (Exception ex) {
                        try {
                            debuggerClass = Class.forName("org.jivesoftware.smack.debugger.LiteDebugger");
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                    }
                }
                try {
                    Constructor<?> constructor = debuggerClass.getConstructor(XMPPConnection.class, Writer.class, Reader.class);
                    this.debugger = (SmackDebugger)constructor.newInstance(this, this.writer, this.reader);
                    this.reader = this.debugger.getReader();
                    this.writer = this.debugger.getWriter();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DEBUG_ENABLED = false;
                }
            } else {
                this.reader = this.debugger.newConnectionReader(this.reader);
                this.writer = this.debugger.newConnectionWriter(this.writer);
            }
        }
    }

    public boolean isUsingTLS() {
        return this.usingTLS;
    }

    public SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    protected ConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    void startTLSReceived(boolean required) {
        if (required && this.configuration.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.packetReader.notifyConnectionError(new IllegalStateException("TLS required by server but not allowed by connection configuration"));
            return;
        }
        if (this.configuration.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            return;
        }
        try {
            this.writer.write("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
            this.writer.flush();
        }
        catch (IOException e) {
            this.packetReader.notifyConnectionError(e);
        }
    }

    void proceedTLSReceived() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new ServerTrustManager(this.serviceName, this.configuration)}, new SecureRandom());
        Socket plain = this.socket;
        this.socket = context.getSocketFactory().createSocket(plain, plain.getInetAddress().getHostName(), plain.getPort(), true);
        this.socket.setSoTimeout(0);
        this.socket.setKeepAlive(true);
        this.initReaderAndWriter();
        ((SSLSocket)this.socket).startHandshake();
        this.usingTLS = true;
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
    }

    void setAvailableCompressionMethods(Collection methods) {
        this.compressionMethods = methods;
    }

    private boolean hasAvailableCompressionMethod(String method) {
        return this.compressionMethods != null && this.compressionMethods.contains(method);
    }

    public boolean isUsingCompression() {
        return this.usingCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean useCompression() {
        if (this.authenticated) {
            throw new IllegalStateException("Compression should be negotiated before authentication.");
        }
        try {
            Class.forName("com.jcraft.jzlib.ZOutputStream");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot use compression. Add smackx.jar to the classpath");
        }
        if (this.hasAvailableCompressionMethod("zlib")) {
            this.requestStreamCompression();
            XMPPConnection xMPPConnection = this;
            synchronized (xMPPConnection) {
                try {
                    this.wait(SmackConfiguration.getPacketReplyTimeout() * 5);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.usingCompression;
        }
        return false;
    }

    private void requestStreamCompression() {
        try {
            this.writer.write("<compress xmlns='http://jabber.org/protocol/compress'>");
            this.writer.write("<method>zlib</method></compress>");
            this.writer.flush();
        }
        catch (IOException e) {
            this.packetReader.notifyConnectionError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startStreamCompression() throws Exception {
        this.usingCompression = true;
        this.initReaderAndWriter();
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamCompressionDenied() {
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    public void connect() throws XMPPException {
        this.connectUsingConfiguration(this.configuration);
        if (this.connected && this.wasAuthenticated) {
            try {
                if (this.isAnonymous()) {
                    this.loginAnonymously();
                } else {
                    this.login(this.getConfiguration().getUsername(), this.getConfiguration().getPassword(), this.getConfiguration().getResource(), this.getConfiguration().isSendPresence());
                }
            }
            catch (XMPPException e) {
                e.printStackTrace();
            }
        }
    }

    private void setWasAuthenticated(boolean wasAuthenticated) {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = wasAuthenticated;
        }
    }

    static {
        try {
            DEBUG_ENABLED = Boolean.getBoolean("smack.debugEnabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SmackConfiguration.getVersion();
    }
}

