/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.RelationalOperator;
import java.math.BigDecimal;
import java.math.BigInteger;

public class GreaterThanOrEqualsOperator
extends RelationalOperator {
    public static final GreaterThanOrEqualsOperator SINGLETON = new GreaterThanOrEqualsOperator();

    public String getOperatorSymbol() {
        return ">=";
    }

    public Object apply(Object pLeft, Object pRight) throws ElException {
        if (pLeft == pRight) {
            return Boolean.TRUE;
        }
        if (pLeft == null || pRight == null) {
            return Boolean.FALSE;
        }
        return super.apply(pLeft, pRight);
    }

    public boolean apply(double pLeft, double pRight) {
        return pLeft >= pRight;
    }

    public boolean apply(long pLeft, long pRight) {
        return pLeft >= pRight;
    }

    public boolean apply(String pLeft, String pRight) {
        return pLeft.compareTo(pRight) >= 0;
    }

    public boolean apply(BigDecimal pLeft, BigDecimal pRight) {
        return this.isGreater(pLeft.compareTo(pRight)) || this.isEqual(pLeft.compareTo(pRight));
    }

    public boolean apply(BigInteger pLeft, BigInteger pRight) {
        return this.isGreater(pLeft.compareTo(pRight)) || this.isEqual(pLeft.compareTo(pRight));
    }
}

