'''
Resource Objects
Created on 30.06.2009

@author: hmueller
'''

class Resource(object):

    def __init__(self):
        self.items = []
        self.comments = []
    
    def __str__(self):
        s = "\n".join(self.comments) 
        s += self.__name__ + "{\n"
        for d in self.items:
            s += "  " + str(d) + "\n"
        s += "}\n"
        return s
    
    def add_comment(self, comment):
        if not comment.lstrip().startswith("#"):
            comment = "# " + comment
        self.comments.append(comment)

class Director(Resource):
    pass

class Job(Resource):
    DIRECTIVE="Job"

class JobDefs(Resource):
    DIRECTIVE="JobDefs"

class Schedule(Resource):
    DIRECTIVE="Schedule"

class FileSet(Resource):
    DIRECTIVE="FileSet"

class Client(Resource):
    DIRECTIVE="Client"

class Storage(Resource):
    DIRECTIVE="Storage"

class Pool(Resource):
    DIRECTIVE="Pool"

class Catalog(Resource):
   # ITEMS_DIRD = cdef.dird_cat_items
    DIRECTIVE="Catalog" 

class Messages(Resource):
    DIRECTIVE=""

class Console(Resource):
    DIRECTIVE=""

class Counter(Resource):
    DIRECTIVE=""

class Device(Resource):
    DIRECTIVE=""

class Autochanger(Resource):
    DIRECTIVE=""
