'''
Resource Objects
Created on 30.06.2009

@author: hmueller
'''



class Resource(object):
    serial=0

    def __init__(self, level=0,name=None):
        Resource.serial=Resource.serial+1
        self.items = []
        self.comments = []
        self._recurselevel = level
        self.type = name
        self.value = None
        self.id=Resource.serial

    def __str__(self):

        equalsign_hack=[ 'diraddresses', 'ip', 'ipv4' ]

        s = "\n".join(self.comments) 
        indent="  "*self._recurselevel
        s += indent+"# id:"+str(self.id)+"\n"

        if len(self.items)==0:
                return indent+self.type+" = "+self.value+"\n";

        if self.type.lower() in equalsign_hack:
            s += indent+self.type + " = {\n";
        else:
            s += indent+self.type + " {\n"
        for d in self.items:
            s += str(d)
        s += indent+"}\n"
        return s
    
    def add_comment(self, comment):
        if not comment.lstrip().startswith("#"):
            comment = "# " + comment
        self.comments.append(comment)
        
    def add_item(self, item):
        self.items.append(item)

    def add(self,type,value):
        newRes=Resource()
        newRes.type=type
        newRes.value=value
        newRes._recurselevel=self._recurselevel+1
        self.items.append(newRes)

    def getById(self,theid):
        if self.id==theid:
                return self

        for r in self.items:
                result=r.getById(theid)
                if result:
                        return result
        return None

    def getByType(self,name,depth=10000):
        result=[]
        if self.type==name:
                result.append(self)
        if depth>0:
            for i in self.items:
                r=i.getByType(name,depth-1)
                if len(r)!=0:
                    for a in r:
                        result.append(a)
        return result
                          
    def getName(self):
        for i in self.items:
            if i.type=="Name":
                return i.value
        return None

    def getByName(self,name):
        result=[]
        if self.getName()==name:
            result.append(self)
        for i in self.items:
            r=i.getByName(name)
            if len(r)!=0:
                for a in r:
                    result.append(a)
        return result

class Root(Resource):
    def __str__(self):
	s=""
        for d in self.items:
            s += str(d)
        return s

class Director(Resource):
    pass

class Job(Resource):
    def setDefaults(self,jobName,clientName,jobDefs,fileset):
        self.add("Name",'"'+jobName+'"')
        self.add("Client",clientName)
        self.add("JobDefs",'"'+jobDefs+'"')
        self.add("FileSet",'"'+fileset+'"')
        
class JobDefs(Resource):
    pass

class Schedule(Resource):
    pass

class FileSet(Resource):
    pass

class Client(Resource):
    def setDefaults(self,clientname,clientaddr,catalog,password):
        self.add("Name",clientname)
        self.add("Address",clientaddr)
        self.add("Catalog",catalog)
        self.add("Password",'"'+password+'"')

class Storage(Resource):
    pass

class Pool(Resource):
    pass

class Catalog(Resource):
    pass

class Messages(Resource):
    pass

class Console(Resource):
    pass

class Counter(Resource):
    pass

class Device(Resource):
    pass

class Autochanger(Resource):
    pass

class FileDaemon(Resource):
    pass

