from ZSI.ServiceContainer import ServiceContainer, SOAPRequestHandler
from ZSI.schema import LocalElementDeclaration, ElementDeclaration, TypeDefinition, GTD, GED
from VanHelsing_server import VanHelsing
from VanHelsing_types import ns0
import VanHelsingWrapper
import sys

ResourceInfo= GTD("http://www.dass-it.de/VanHelsing/", "ResourceInfo")(None).pyclass()
listResourcesType= GTD("http://www.dass-it.de/VanHelsing/", "listResourcesType")(None).pyclass()
#print dir(ResourceInfo)

class VanSOAPRequestHandler(SOAPRequestHandler):
    def do_GET(self):
        wsdl=open("VanHelsing.wsdl").read()
        self.send_xml(wsdl)

def AsServer(port=80, services=(), RequestHandlerClass=SOAPRequestHandler):
    address = ("127.0.0.1",port)
    sc = ServiceContainer(address, RequestHandlerClass=RequestHandlerClass)
    for service in services:
        path = service.getPost()
        sc.setNode(service,path)
    sc.serve_forever()


class RealVanHelsing(VanHelsing):
    def soap_listResources(self, ps, **kw):
        request,response=VanHelsing.soap_listResources(self,ps)

        resType=request.get_element_resourceType()
        resDirector=request.get_element_director()
        
        result=VanHelsingWrapper.getResources(resDirector,resType)

        rList=[]

        for rid,name in result:

            resInf=response.new_resource()
            resInf.set_element_director(resDirector)
            resInf.set_element_resId(rid)
            resInf.set_element_resType(resType)
            resInf.set_element_resName(name)
            rList.append(resInf)

        response.set_element_resource(rList)

        return request,response

    def soap_getSimpleResource(self, ps, **kw):
        request,response=VanHelsing.soap_getSimpleResource(self,ps)

        resId=request.get_element_resId()
        resDirector=request.get_element_director()

        print resId

        resource=VanHelsingWrapper.getResourceById(resDirector,resId)
        attributes=VanHelsingWrapper.keyValueList(resource)

        resInf=response.new_resInfo()
        print dir(response)
        resInf.set_element_director(resDirector)
        resInf.set_element_resId(resId)
        resInf.set_element_resType("type")
        resInf.set_element_resName("name")

        response.set_element_resInfo(resInf)

        attrlist=[]

        for k,v in attributes:
            resAttr=response.new_resAttribute()
            resAttr.set_element_key(k)
            resAttr.set_element_value(v)
            attrlist.append(resAttr)
        response.set_element_resAttribute(attrlist)

        return request,response

    def soap_setSimpleResource(self, ps, **kw):
        request,response=VanHelsing.soap_setSimpleResource(self, ps)

        resInfo = request.get_element_resInfo()
        resId = resInfo.get_element_resId()
        director = resInfo.get_element_director()
        attributes = request.get_element_resAttribute()

        resId, status = VanHelsingWrapper.setResourceById(resId, director, attributes, resInfo)
        response.set_element_resId(resId)
        response.set_element_status(status)

        return request, response

if 1:
    if len(sys.argv) < 2:
        filename="test.conf"
    else:
        filename=sys.argv[1]   

    VanHelsingWrapper.loadDirectorConfig(filename)

    AsServer(port=8080,services=[ RealVanHelsing() ], RequestHandlerClass=VanSOAPRequestHandler)

