/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ListDataModel
extends DataModel {
    private int _rowIndex = -1;
    private List _data;

    public ListDataModel() {
    }

    public ListDataModel(List list) {
        if (list == null) {
            throw new NullPointerException("list");
        }
        this.setWrappedData(list);
    }

    public int getRowCount() {
        if (this._data == null) {
            return -1;
        }
        return this._data.size();
    }

    public Object getRowData() {
        if (this._data == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this._data.get(this._rowIndex);
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public Object getWrappedData() {
        return this._data;
    }

    public boolean isRowAvailable() {
        if (this._data == null) {
            return false;
        }
        return this._rowIndex >= 0 && this._rowIndex < this._data.size();
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + rowIndex);
        }
        int oldRowIndex = this._rowIndex;
        this._rowIndex = rowIndex;
        if (this._data != null && oldRowIndex != this._rowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent(this, this._rowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    public void setWrappedData(Object data) {
        this._data = (List)data;
        int rowIndex = this._data != null ? 0 : -1;
        this.setRowIndex(rowIndex);
    }
}

